#include "mbed.h"
#include "TextLCD.h"

//IO
TextLCD lcd(p27,p28,p23,p24,p25,p26); //RS E d1,d2,d3,d4
DigitalIn HrAdjustUp(p6);
DigitalIn HrAdjustDown(p7);
DigitalIn MinAdjust(p8);    //buttons for setting time and alarm
DigitalIn AlarmAdjust2(p9);

DigitalOut arm(p12);
// 1454284799 is the end of Febuary 

struct tm* t;
int Ahh,AHH,Amm; 
int HH,mm,hh;       //HH 24hr || hh 12hr
char d,ad;          //am0/pm1
Timer set; 

void time_init(void){           //starting time and timers   
    set.start();
    set_time(1454284799+10);
    AHH=12;Amm=0;
}

void timeDisplay(void){                     //main time management function and display
    time_t rawTime;
    time(&rawTime);    
    t = localtime(&rawTime);
    HH=t->tm_hour; mm=t->tm_min;                        //updating local hr and min var
    
    //TIME format
    if(HH>12)hh=HH-12;  else hh=HH+0.1;                // I don't know why this makes it work but it does
    if(HH ==0){hh = HH+12.1;}
                   //convert 24 to 12 hr
    if(HH>=12) d='P';     else d='A';                   //update am/pm
    //Alarm format
    if(AHH>12)Ahh=AHH-12;   else Ahh=AHH;             //convert 24 to 12 hr
    if(AHH>=12) ad='P';     else ad='A';
             
    lcd.printf("  %2d/%.2d %2d:%.2d%cM Alarm -> %2I:%.2I%cM" , t->tm_mon+1,t->tm_mday,hh,t->tm_min,d,Ahh,Amm,ad);  //Print date(month/day), time    
}    
    
char checkAlarm(void){
    if(HH==AHH&&mm==Amm&&d==ad) return 1;
    else return 0;
}

void alarmProg(void){           //Alarm set/adjust function to be called in main, when alarm set switch is enabled
    if(set.read()>0.3){   
        if(HrAdjustUp==1) {AHH=AHH+1;set.reset();}
        if(HrAdjustDown==1) {AHH=AHH-1;set.reset();}
        if(MinAdjust==1) {Amm=Amm+1;set.reset();}
        if(AHH>23) AHH=0; if(AHH<0) AHH=23;
        if(AHH>=12) ad='P'; else ad='A';
        if(Amm>=60) Amm=0;
    }
}

void timeProg(void){
    time_t seconds = time(NULL);
    if(set.read()>0.3){
         if(HrAdjustUp==1 && AlarmAdjust2 ==1){  // Adjust Day Forward
            set_time(seconds+86400);
            set.reset();
        }
         else if(HrAdjustUp==1){
            set_time(seconds+60*60);
            set.reset();
        }
        if(HrAdjustDown==1 && AlarmAdjust2 ==1){  // Adjust Day Backward
            set_time(seconds- 86400);
            set.reset();
        }
        else if(HrAdjustDown==1){
            set_time(seconds-60*60);
            set.reset();
        }
        else if(MinAdjust==1){
            set_time(seconds+60);
            set.reset();
        }
    }
}

