#include "mbed.h"
PwmOut buzzer1(p21);
PwmOut buzzer2(p22);
DigitalOut led1(LED1);
DigitalOut led3(LED3);
bool go = true;  // variable to control if the alarm sounds
Timeout reset;  // resets the alarm so that it will not sound in an endless loop

float frequency[] = {262,0,262,0,262,0,349,0,523,0,466,0,440,0,392,0,698,0,523,0,466,0,440,0,392,0,698,0,523,0,466,0,440,0,466,0,392,0,/**/};
float beat[] = {.3,0,.3,0,.3,0,2,0,2,0,.3,0,.3,0,.3,0,2,0,1,0,.3,0,.3,0,.3,0,2,0,1,0,.3,0,.3,0,.3,0,2,0/**/};
float frequency2[] = {262,0,262,0,294,0,294,0,466,0,440,0,392,0,349,0,349,0,392,0,440,0,392,0,294,0,330,0,523,0,523,0,698,0,622,0,554,0,523,0,466,0,415,0,392,0,349,0,523,0};
float beat2[] = {.75,0,.25,0,1.5,0,.5,0,.5,0,.5,0,.5,0,.5,0,.3,0,.3,0,.3,0,1,0,.5,0,1,0,.75,0,.25,0,1,0,.5,0,1,0,.5,0,1,0,.5,0,1,0,.5,0,4,0};

void turn_on(void);  // Makes the alarm able to sound
void turn_off(void); // Turns of the alarm sound

void Sound_Alarm()
{
    while(go)  // Plays Star Wars
    {
        led1 = !led1;
        wait(.5);
        
        for(int i=0; i<= 37;i++)
        {
            buzzer1.period(2/(frequency[i]));
            buzzer2.period(2/(frequency[i]));
            buzzer1 = 0.5;
            buzzer2 = 0.5;
            if(!go)
            {
                buzzer1 = 0;
                buzzer2 = 0;
                reset.attach(&turn_on,60.0);   // Exit then Re-enable the alarm system after 60 seconds
                break;
            }
            
            wait(0.4*beat[i]); 
            if(beat[i]==0)
            {wait(.05);}
          
        }
        
        for(int i=0; i<= 49;i++)
        {
            buzzer1.period(2/(frequency2[i]));
            buzzer2.period(2/(frequency2[i]));
            buzzer1 = 0.5;
            buzzer2 = 0.5;
            
            if(!go)
            {
                buzzer1 = 0;
                buzzer2 = 0;
                reset.attach(&turn_on,60.0);  // Exit then Re-enable the alarm system after 60 seconds
                break;
            }
            
            wait(0.4*beat2[i]); 
            if(beat2[i]==0)
            {wait(.05);}
          
        }
        
    }
        
}    

void turn_off()
{
    go = false;
    led1 =0;
    led3 =0;    
}

void turn_on()
{
    go = true; 
    led3 =1;     
}

