#include "mbed.h"
#include "ODBII.h"
#include "globals.h"
#include "pavement_48x34.h"
#include "ILI932x.h"
#include "Arial24x23.h"
/*
This is Ben and I's final project for Embedded Systems. Our goal was to create a car diagnostic system that interfaces with 
the CAN bus in all US sold cars newer than 2008. We aimed to request data such as RPM, Vehicle speed, engine temp, etc and then 
display our findings. This software was succussful in communicating with the car and reading and writing, however it fails
to accompolish it's task when dealing with certain makes of cars, specifically Honda. Included are various PID codes, functions,
and files that interface with a car's CAN bus system.
*/
PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23};
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320);
char orient = 3;
void refresh(float engine);


int main() 
{
    set_frequency(CANSPEED_500);//set the frequency to deal with the main engine ECU
    float engine_info;
    myLCD.set_orientation(orient);
    myLCD.background(Black);
    myLCD.foreground(White);
    myLCD.set_font((unsigned char*) Arial24x23);
    while(1)
    {
        if (request(ENGINE_RPM)) //used to check if we can get valid data back
        {
            engine_info = request(ENGINE_RPM);//if we can, then we're all set to go!
            refresh(engine_info);
        }
        wait(3);
    }

    
}

void refresh(float engine)
{
    myLCD.locate(myLCD.width()/2, myLCD.height()/2);
    myLCD.printf("Your info is: %f\n\r", engine);
}
    
