#ifndef EXTENDED_TIMER_H
#define EXTENDED_TIMER_H

#include "mbed.h"

/** A timer appropriate for intervals up to about 20 days
 *
 *  @author John M. Larkin (jlarkin@whitworth.edu)
 *  @version 0.1
 *  @date 2017
 *  @copyright GNU Public License
 */

class ExtendedTimer {

public:
    ExtendedTimer();
    
    /** Start the timer        
    */
    void start();
    
    /** Stop the timer
    */
    void stop();
    
    /** Reset the timer to 0
    *
    *  If it was already counting, it will continue
    */
    void reset();

    /** Get the time passed in milliseconds
    */
    int read_ms();
    
    /** Get the time passed in seconds
    */
    float read();
    
    /** An operator shorthand for read()
    */
    operator float();
    

    
protected:
    int _running; // whether the timer is running
    unsigned int _time; // any accumulated time from previous slices
    Timer usTimer;
    Ticker usTimerWatch;
    void usTimerReset();
};
#endif