#include "ExtendedTimer.h"

ExtendedTimer::ExtendedTimer() : _running(), _time() {
    reset();
}

void ExtendedTimer::start() {
    if (!_running) {
        usTimer.reset();
        usTimer.start();
        _running = 1;
        usTimerWatch.attach(this, &ExtendedTimer::usTimerReset,1800);
    }
}

void ExtendedTimer::stop() {
    usTimer.stop();
    usTimerWatch.detach();
    _time += usTimer.read_ms();
    _running = 0;
}

int ExtendedTimer::read_ms() {
    return _time + usTimer.read_ms();
}

float ExtendedTimer::read() {
    return (float)read_ms()/1000.0f;
}

void ExtendedTimer::reset() {
    usTimer.reset();
    _time = 0;
}

ExtendedTimer::operator float() {
    return read();
}

void ExtendedTimer::usTimerReset() {
    _time += usTimer.read_ms();
    usTimer.reset();
}
