/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.
 
 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.
 
 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/
 
#ifndef DM_TOUCH_h
#define DM_TOUCH_h
 
#include "mbed.h"
//#include "dm_platform.h"  // What is needed from dm_platform.h?

#define sbi(reg, _bitmask) (*(reg) = 1)
#define cbi(reg, _bitmask) (*(reg) = 0)
#define delay(ms) wait_ms(ms)
#define pulse_high(reg, _bitmask) do { *(reg) = 1; *(reg) = 0; } while(0)
#define pulse_low(reg, _bitmask) do { *(reg) = 0; *(reg) = 1; } while(0)
#define slow_pulse_high(reg, _bitmask) do {\
   *(reg) = 1;    \
   slow_pulse_delay(); \
   *(reg) = 0;    \
   slow_pulse_delay(); \
} while(0)
#define slow_pulse_low(reg, _bitmask) do {\
   *(reg) = 0;    \
   slow_pulse_delay(); \
   *(reg) = 1;    \
   slow_pulse_delay(); \
} while(0)
#define slow_pulse_delay()
 
typedef struct calibrationMatrix {
  int  a, b, c, d, e, f;
} CalibrationMatrix;
 
class DmTouch
{
public:
  enum Display {
    DM_TFT28_103 = 103,
    DM_TFT24_104 = 104,
    DM_TFT28_105 = 105,
    DM_TFT35_107 = 107,
    DM_TFT43_108 = 108,
    DM_TFT50_111 = 111
  };
 
  enum SpiMode {
    Auto,
    Software,
    Hardware
  };
  
  enum TouchId{
    IC_8875 = 0x8875,
    IC_2046 = 0x2046        
  };

  DmTouch(Display disp, PinName mosi, PinName miso, PinName clk, PinName cs, PinName irq);      // Add cs and irq to input parameters
  void init();
  void readTouchData(uint16_t& posX, uint16_t& posY, bool& touching);
  bool isTouched();
  bool getMiddleXY(uint16_t &x, uint16_t &y); // Raw Touch Data, used for calibration
  void setCalibrationMatrix(CalibrationMatrix calibrationMatrix);
  void setPrecison(uint8_t samplesPerMeasurement);
  void waitForTouch();
  void waitForTouchRelease();
  uint32_t rescaleFactor() { return 1000000; };
  Display getDisplay() { return _disp; };
  static CalibrationMatrix getDefaultCalibrationData(Display disp);                             // (JML) Added to this class because avoid DmTouchCalibration initially
  void setOrientation(char orient);                                                             // Set screen orientation mode
 
private:
  void spiWrite(uint8_t data);
  uint8_t spiRead();
  uint16_t readData12(uint8_t command);
  void enableIrq();
  void readRawData(uint16_t &x, uint16_t &y);
  void getAverageXY(uint16_t &x, uint16_t &y);
  uint16_t getDisplayCoordinateX(uint16_t x_touch, uint16_t y_touch);
  uint16_t getDisplayCoordinateY(uint16_t x_touch, uint16_t y_touch);
  uint16_t calculateMiddleValue(uint16_t values[], uint8_t count);
  bool isSampleValid();
 
  Display _disp;
  uint16_t _width, _height;
  bool _hardwareSpi;
  uint8_t _samplesPerMeasurement;
  CalibrationMatrix _calibrationMatrix;
  uint16_t _touch_id;
  char _orient;                                                         // Adjust to changes in screen orientation
 
  PinName _cs, _clk, _mosi, _miso, _irq;
  DigitalOut *_pinDC, *_pinCS, *_pinCLK, *_pinMOSI, *_led;
  DigitalIn *_pinMISO, *_pinIrq;
  SPI *_spi;
};
#endif