/* Do not publish changes to this program back to the remote repository.  Fork your own copy, or else */
#include "stdio.h"
#include "mbed.h"
#include "string"
#include "ILI932x.h"
#include "DmTouch.h"


#include "Arial12x12.h"
#include "Arial24x23.h"
#include "pavement_48x34.h"

Serial pc(USBTX, USBRX);

/* Configure the DisplayModule ILI9325 2.4" display for 8-bit bus communication

    mbed pin    display pin
    --------    -----------
    p15         CS (L15)
    p17         RST (L17)
    p16         RS (L4)
    p14         WR (L5)
    p20         RD (L6)
    
    p30         DB8 (L7)
    p29         DB9 (L8)
    p28         DB10 (L9)
    p27         DB11 (L10)
    p26         DB12 (L11)
    p25         DB13 (L12)
    p24         DB14 (L13)
    p23         DB15 (L14)
    
    p1          GND (L1)
    p40         Vin (L2)
    p40         LED Backlight (L19)
*/  
PinName dataBus[]= {p30, p29, p28, p27, p26, p25, p24, p23};
ILI932x myLCD(BUS_8, dataBus, p15, p17, p16, p14, p20, "myLCD", 240, 320); // Bus 8 bit, bus pin array, CS, RST, DC, WR, RD, name, xpixels, ypixels

/* Additional connections to add touch response

    mbed pin    display pin
    --------    -----------
    p5          T_MOSI (R11)
    p6          T_MISO (R13)
    p7          T_CLK (R9)
    p8          T_CS (R10)
    p9          T_IRQ (R14)
*/
DmTouch touch(DmTouch::DM_TFT24_104, p5, p6, p7, p8, p9);

char orient=3;
int x,y;
uint16_t tx, ty;
Timer t;

int main()
{
    bool down, lastDown;
    touch.init();
    t.start();
    myLCD.set_orientation(orient);
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.background(Blue);    // set background to Blue
    myLCD.foreground(White);    // set chars to White
    myLCD.cls();                // clear the screen
    myLCD.locate(10,30);
    myLCD.printf("UniGraphics Demo\r\n");
    wait(2);
    
    while(1)
    {
        myLCD.cls();  // clear the screen
        myLCD.set_font((unsigned char*) Arial24x23);
        myLCD.locate(0,30);
        myLCD.printf("Orientation mode: %x\r\n", orient%4);
        wait(2);
        myLCD.printf("Font is\r\n");
        myLCD.printf("Arial24x23\r\n");
        wait(2);
        
        myLCD.background(Black);
        myLCD.foreground(White);
        myLCD.cls();                // clear the screen
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.locate(0,10);
        myLCD.printf("Font changed to Arial12x12\r\n");
        myLCD.printf("Background and foreground color also changed.\n\r\n\r");
        wait(2);
        myLCD.printf("Notice that if some text is too long to fit the width of the screen that it is automatically wrapped to the next line.\r\n\r\n");
        wait(2);
        myLCD.set_font((unsigned char*) Terminal6x8);
        myLCD.printf("Font changed to Terminal6x8\r\n");
        myLCD.printf("This is pretty small!\r\n");
        wait(2);
        
        myLCD.cls();
        myLCD.set_font((unsigned char*) Arial24x23);
        myLCD.locate(10,10);
        myLCD.printf("Draw lines\n\r");
        myLCD.line(0,50,myLCD.width()-1,50,Yellow);
        myLCD.line(myLCD.width()-50,51,myLCD.width()-50,myLCD.height()-1,Green);
        wait(2);        
        
        myLCD.cls();
        myLCD.locate(10,10);
        myLCD.printf("Draw rectangles");
        myLCD.rect(10,50,50,80,Red);
        myLCD.rect(15,55,45,75,Red);
        myLCD.rect(20,60,40,70,Red);
        myLCD.fillrect(160,130,200,240,Blue);
        wait(2);
        
        myLCD.cls();
        myLCD.locate(10,10);
        myLCD.printf("Draw circles");
        myLCD.circle(150,132,30,Yellow);
        myLCD.fillcircle(140,70,25,Cyan);
        wait(2);
        
        myLCD.cls();
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.locate(10,10);
        myLCD.printf("Draw function with pixels");
        double s;
        for (unsigned short i=0; i<myLCD.width(); i++)
        {
        s =10 * sin((long double) i / 10 );
        myLCD.pixel(i,80 + (int)s ,White);
        }
        wait(3);
        
        // Touch screen demo
        myLCD.background(Blue);    // set background to Blue
        myLCD.foreground(White);    // set chars to White
        myLCD.cls();                // clear the screen
        myLCD.locate(10,30);
        myLCD.set_font((unsigned char*) Arial24x23);
        myLCD.printf("DmTouch Demo\r\n");
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.locate(10,70);
        myLCD.printf("Coming soon...\r\nTouch screen and coordinates will display\r\n");
        myLCD.printf("Moves to next portion of demo after 30 seconds\r\n");
        wait(2);
        myLCD.background(Black);    // set background to Black
        myLCD.foreground(White);    // set chars to White
        myLCD.cls();                // clear the screen

        touch.setOrientation(orient);
        down = false;
        lastDown = false;
        tx = (uint16_t)0;
        ty = (uint16_t)0;
        myLCD.locate(20,20);
        myLCD.printf("x:");
        myLCD.locate(100, 20);
        myLCD.printf("y:");

        t.reset();
        while (t.read()<30) {
            touch.readTouchData(tx, ty, down);
            if (down) {
                myLCD.locate(40, 20);
                myLCD.printf("%5i", tx);
                myLCD.locate(120, 20);
                myLCD.printf("%5i", ty);
                myLCD.fillcircle(tx, ty, 2, Red);
            } else if (lastDown) {
                // no longer pressed, clean text
                myLCD.locate(40, 20);
                myLCD.printf("     ", tx);
                myLCD.locate(120, 20);
                myLCD.printf("     ", ty);
            }
            wait(0.040);
            lastDown = down;
          }
        
        
    // scroll test, only for TFT
    myLCD.cls();
    myLCD.set_font((unsigned char*) Arial24x23);
    myLCD.locate(2,10);
    myLCD.printf("Scrolling");
    myLCD.rect(0,0,myLCD.width()-1,myLCD.height()-1,White);
    myLCD.rect(1,1,myLCD.width()-2,myLCD.height()-2,Blue);
    myLCD.setscrollarea(0,myLCD.sizeY());
    wait(1);
    myLCD.scroll(1); //up 1
    wait(1);
    myLCD.scroll(0); //center
    wait(1);
    myLCD.scroll(myLCD.sizeY()-1); //down 1
    wait(1);
    myLCD.scroll(myLCD.sizeY()); // same as 0, center
    wait(1);
    myLCD.scroll(myLCD.sizeY()>>1); // half screen
    wait(1);
    myLCD.scrollreset(); // center
    wait(1);
    for(unsigned short i=1; i<=myLCD.sizeY(); i++)
    {
        myLCD.scroll(i);
        wait_ms(2);
    }
    wait(2);
    // color inversion
    for(unsigned short i=0; i<=8; i++)
    {
        myLCD.invert(i&1);
        wait_ms(200);
    }
    wait(2);
    // bmp 16bit test
    myLCD.cls();
    for(int y=0; y<myLCD.height(); y+=34)
    {
        for(int x=0; x<myLCD.width(); x+=48) myLCD.Bitmap(x,y,48,34,(unsigned char *)pavement_48x34);
    }
    wait(2);
    myLCD.set_orientation((++orient)%4);
    }
}