#define MULTIPLE_PROBES
#define DATA_PIN        p25


#ifdef MULTIPLE_PROBES

#include "mbed.h"
#include "DS1820.h"

#define MAX_PROBES      16
 
DS1820* probe[MAX_PROBES];
 
int main() {  
    // Initialize the probe array to DS1820 objects
    int num_devices = 0;
    while(DS1820::unassignedProbe(DATA_PIN)) {
        probe[num_devices] = new DS1820(DATA_PIN);
        num_devices++;
        if (num_devices == MAX_PROBES)
            break;
    }
    
    printf("Found %d device(s)\r\n", num_devices);
    unsigned long long fullName;
    unsigned int firstName;
    unsigned int lastName;
    for (int i = 0; i<num_devices; i++) {
        fullName = probe[i]->whoAmI();
        firstName = fullName >> 32;
        lastName = fullName;
        printf("\tID %d = %x%x\r\n", i, firstName, lastName);
    }
    printf("\n");
    
    while(1) {
        probe[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        for (int i = 0; i<num_devices; i++)
            printf("%3.1f C\t", i, probe[i]->temperature());
        printf("\r\n");
        wait(1);
    }
    
}

#else
#include "mbed.h"
#include "DS1820.h"
 
DS1820 probe(DATA_PIN);
 
int main() {
    while(1) {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        printf("It is %3.1foC\r\n", probe.temperature());
        wait(1);
    }
}

#endif