#include "mbed.h"
#include "ContinuousServo.h"
#include "Tach.h"
Serial pc(USBTX,USBRX);

//sonar sensor
AnalogIn sonar(p19); //range sensor 9.8mV/inch
//servo
ContinuousServo left(p23);
ContinuousServo right(p26);
//encoders
Tach tLeft(p17,64);
Tach tRight(p13,64);
int main()
{
    while(1) {
        float var1;
        int num_iterations;
        int i=1;

        pc.scanf("%d",&num_iterations);//reads in values from the Matlab
        while(i<=num_iterations) {
            i++;
            left.speed(.25);
            right.speed(-0.25);
            var1=num_iterations/3;
            
            if(i==var1) {
                left.speed(.25);
                right.speed(.25);
                wait(0.9);
            }
            if(i==var1*2) {
                left.speed(-0.25);
                right.speed(-0.25);
                wait(0.9);
            }
            wait(0.1);
            pc.printf("%d\n",i);//mbed send out float values for Matlab
        }
        left.stop();
        right.stop();
    }
}


