#include "mbed.h"
Serial pc(USBTX,USBRX);

// Hall effect sensor
DigitalIn hall(p21);
DigitalOut hallpwr(p22);

InterruptIn event(p21);
DigitalOut led1(LED1);
DigitalOut led4(LED4);

int hallvalue;
int hallstatus=0;
void trigger()
{
    while (hallstatus!=0) { // when triggered the lead will send out a light and reset the  hallstatus
        led1=1;
        wait(1);
        led1=0;
        hallstatus=0;
    }
}
int main()
{
    hall.mode(PullUp); // brings up the sensor values
    hallpwr=0; // sets the power readings
    wait(0.2);
    hallpwr =1;// sets the power readings
    wait(0.2);
    event.rise(&trigger); //starts the outside tigger fuctions when something happens on pin 21
    while(1) {
        hallvalue=hall.read();// reads in hall effect values of (0 &1)
        if (hallvalue==1) { // if the value read in is 1 then there is a change in status
            hallstatus=1;
        }
        pc.printf("hallvalues:%d\n\r",hallvalue);
        wait(0.25);
    }
}
