#include "ContinuousServo.h"
 
 //64 counts per rev
 
ContinuousServo::ContinuousServo(PinName output): servo_(output){
    servo_.period_ms(50);
}

void ContinuousServo::speed(float val){
    //convert val from -1,1 to 1.3 to 1.7
    if(val<-1.0)
        val = -1.0;
    if(val>1.0)
        val = 1.0;
    servo_.pulsewidth_us((int)(1500+200*val));
}

void ContinuousServo::stop(){
    servo_.pulsewidth_us(0);
}