#include "mbed.h"
#include "string.h"
#include "stdio.h"
#include "math.h"
#include "C12832.h"
#include "SDHCFileSystem.h"
#include "_bitio.h"
#include <string>
using namespace std;

//Communication\interfaces
Serial pc(USBTX,USBRX); //USB serial
C12832 lcd(p5, p7, p6, p8, p9); //LCD
DigitalIn RW(p10);
SDFileSystem sd(p11, p12, p13, p15, "sd"); //SDCard
DigitalIn sdDetect(p14); //CardDetect

//in- and outputs
DigitalIn PauseBtn(p19);
DigitalIn StopBtn(p20);
DigitalIn UpBtn(p18);
DigitalIn DownBtn(p17);

DigitalOut led1(LED1);
DigitalOut led2(LED2);


//DAC output
// BU9480F define
//SPI bu9480f(p23,p24,p21);
//DigitalOut LRCLK(p22);
// BU9480F define.end

//ticker- sampling
Ticker tick;

//timer
Timer dur;

//func
void read_file_names(char *dir); //SDCard read file names
void menu();
void PlaySong(int m);
void StopSong();
void dac_out();
void encode(long int n);
void decode(void);

//variables
int m = 1; //index of choosen songs
int i = 0; //index of files from folder
int Paused = 0;//Is the song paused?
int Stopped = 0; //Is the song stopped?
char* songs[5];

// a FIFO for the DAC
#define TXFIFO_FULL 1
#define RAM_LENGTH 8192//8192
#define RAM_LIMIT (RAM_LENGTH - 1)
volatile short DAC_fifo[RAM_LENGTH];
volatile short DAC_wptr=0;
volatile short DAC_rptr=0;
volatile short DAC_on;
volatile short DAC_diff=0;

int main()
{
    while(sdDetect == 0) {
        lcd.printf("Insert SD Card!");
        wait(0.5);
    }
    pc.printf("going out of main");
    menu();
}

void menu()
{
    lcd.cls();
    sd.disk_initialize();
    read_file_names("/sd/Music");
    while(1) {
        lcd.cls();
        lcd.printf("Please select a song");
        if(UpBtn == 1) {
            m++;
            if(m == 5) {
                m = 0;
            }
        } else if(DownBtn == 1) {
            m--;
            if(m == -1) {
                m = 4;
            }
        }
        lcd.locate(0,15);
        lcd.printf("%s", (songs[m]));
        if(PauseBtn == 1) {
            pc.printf("going to play song");
            PlaySong(m);
        }
        wait(0.1);
    }
}

void read_file_names(char *dir) // function that reads in file names from sd cards
{
    pc.printf("found files");
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        songs[i] = dirp->d_name;
        i++;
    }
}

void PlaySong(int m)
{
    string songname = songs[m];
    string a = "/sd/Music/";
    string fname = a + songname; //retrieves the file name
    FILE *infp;
    dur.start();
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Now playing");
    infp = fopen(fname.c_str(),"rb"); //opens the music file
    // bu9480f init
    //bu9480f.format(16,0);
    //bu9480f.frequency(16000000); //16MHz
    // bu9480f init.end
    tick.attach_us(&dac_out, 41); //set 24.4kHz sampling data
    decode();
    //plays the music file

    tick.detach();
    fclose( infp );
    menu();
}

void StopSong()
{
    pc.printf("stopped");
    lcd.cls();
    dur.reset();
    tick.detach();
    menu();
}

void dac_out()
{
    pc.printf("playing");
    if(StopBtn == 1) {
        StopSong();
    }
    if(PauseBtn == 1) {
        dur.stop();
        if(Paused == 1) {
            Paused = 0;
            dur.start();
        } else {
        Paused = 1;
        }
    }
    if(Paused == 0) {
        lcd.locate(0,10);
        lcd.printf("%s", (songs[m]));
        //  printf("\t%d\r\n",DAC_diff);
        if (DAC_diff > 1) {
            led2 = 0;

            //LRCLK = 0;
            //bu9480f.write(DAC_fifo[DAC_rptr++]);
            DAC_rptr &= RAM_LIMIT;

            //LRCLK = 1;
            //bu9480f.write(DAC_fifo[DAC_rptr++]);
            DAC_rptr &= RAM_LIMIT;

            DAC_diff-=2;

        } else led2 = 1;
        lcd.locate(0,20);
        lcd.printf("%2.f s", dur.read());
    } else {
        lcd.printf("PAUSED");
    }
}

void encode(long int n)
{
    pc.printf("encoding");
    int zero_shift = 0;

    if(n < 0) {
        putbit(0);                    // sign (put 0:if n as negative)
        n = -n;                        // n = abs(n)
        //printf("\t 0");
    } else {
        putbit(1);                    // sign (put 1:if n as positive)
        //printf("\t 1");
    }
    zero_shift = (n >> (k));
    //printf("\t shift= %d",zero_shift);
    while(zero_shift > 0) {

        zero_shift--;
        putbit(0);
    }    // put n/(2^k) 0's

    putbit(1);                        // terminating "1"
    putbits(k,rightbits(k,n));
    //printf("\t finish= %d \r\n",(n & ((1U<<k)-1)));
}



void decode(void)
{
    pc.printf("decoding");
    //short dac_data;
    long int decode_buff;
    short diff,diff2;
    unsigned int buff_sign,zero_shift;
    //char flag;

    diff = 0;
    diff2 = 0;
    // get sign(1 for positive, 0 for negative)
    while(1) {

        if((buff_sign = getbit())==OVERRUN)break;
        zero_shift = 0;
        while(getbit()==0)zero_shift++;

        decode_buff = (signed int)((1U << k)*zero_shift);
        decode_buff += (getbits(k));

        if(!buff_sign)decode_buff =- decode_buff;
        /* return decode_buff; */
        diff =(diff + decode_buff);
        DAC_fifo[DAC_wptr++]=(short)diff;
        DAC_wptr &= RAM_LIMIT;
        //DAC_diff++;
        while (DAC_diff > RAM_LIMIT) {
            led1 = 1;
        }   //wait
        led1=0;

        if((buff_sign = getbit())==OVERRUN)break;
        zero_shift = 0;
        while(getbit()==0)zero_shift++;

        decode_buff = (signed int)((1U << k)*zero_shift);
        decode_buff += (getbits(k));

        if(!buff_sign)decode_buff =- decode_buff;
        /* return decode_buff; */
        diff2 =(diff2 + decode_buff);

        DAC_fifo[DAC_wptr++]=(short)diff2;
        DAC_wptr &= RAM_LIMIT;
        DAC_diff+=2;

        while (DAC_diff > RAM_LIMIT) {
            led1 = 1;
        }   //wait
        led1=0;



    }
}
