#include "mbed.h"
#include "string.h"
#include "stdio.h"
#include "math.h"
#include "C12832.h"
#include "WavPlayer.h"
#include "SDFileSystem.h"
#include <string>
using namespace std;

//Communication\interfaces
Serial pc(USBTX,USBRX); //USB serial
C12832 lcd(p5, p7, p6, p8, p11); //LCD
SDFileSystem sd(p11, p12, p13, p15, "sd"); //SDCard
DigitalIn sdDetect(p14); //CardDetect

//in- and outputs
DigitalIn PauseBtn(p21);
DigitalIn StopBtn(p22);

//joystick
BusIn joy(p19,p17,p18,p20);
DigitalIn joyBtn(p14);

//DAC output
WavPlayer waver; //set up DAC to use wave player library


//timer
Timer dur;

//func
void read_file_names(char *dir); //SDCard read file names
void menu();
void PlaySong(int m);
void PauseSong();
void StopSong();

//variables
int m = 1; //index of choosen songs
int i = 0; //index of files from folder
int Paused = 0; //Is the song paused?
int Stopped = 0; //Is the song stopped?
char* songs[5];

int main()
{
    while(sdDetect == 0) {
        lcd.locate(0,0);
        lcd.printf("Insert SD Card!");
        wait(0.5);
    }
    menu();
}

void menu()
{
    lcd.cls();
    sd.disk_initialize();
    read_file_names("/sd/Music");
    while(1) {
        lcd.locate(0,0);
        lcd.printf("Please select a song");
        if(joy == 1) {
            m++;
            if(m == 5) {
                m = 0;
            }
        } else if(joy == 2) {
            m--;
            if(m == -1) {
                m = 4;
            }
        }
        lcd.locate(0,15);
        lcd.printf("%s", (songs[m]));
        if(joyBtn == 1) {
            PlaySong(m);
        }
        wait(0.1);
    }
}

void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        songs[i] = dirp->d_name;
        i++;
    }
}

void PlaySong(int m)
{
    string songname = songs[m];
    string a = "/sd/Music/";
    string fname = a + songname; //retrieves the file name
    FILE *wave_file;
    dur.start();
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Now playing");
    wave_file = fopen(fname.c_str(),"r"); //opens the music file
    waver.open(&wave_file);
    waver.play(); //plays the music file
    lcd.locate(0,10);
    lcd.printf("%s", (songs[m]));
    while(Stopped == 0) {
        if(StopBtn == 1) {
            StopSong();
        }
        if(PauseBtn == 1) {
            PauseSong();
        }
        lcd.locate(0,20);
        lcd.printf("%2.f s", dur.read());
    }
    fclose(wave_file);
    menu();
}

void PauseSong()
{
    while(1) {
        if(Paused == 0) {
            string songname = songs[m];
            unsigned index = songname.find(".wav");
            songname = songname.substr(0,index);
            lcd.printf(songname.c_str());
            dur.stop();
            Paused = 1;
        } else if(StopBtn == 1) {
            StopSong();
        } else {
            Paused = 0;
            dur.start();
        }
    }
}

void StopSong()
{
    lcd.cls();
    dur.reset();
    Stopped = 1;
}
