#include "TextLCD.h"
#include "general_control.h"
#include "temp.h"

Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p25, p26, p24, p23, p22, p21); // rs, e, A4-A7
InterruptIn rfl_swt(p6), rsm_htr(p5);                                           //Refill switch, resume heater
DigitalOut led1(p28), led2(p29), buzzer(p30);                                   //led1 (Green-normal operation), led2 (under/overflow), buzzer


int bC, pw_csv, sw_csv, pwTC, pwTV, swTC, swTV;                                 //Beaker Capacity, Current syringe pure water volume (ml), Current syringe salted water volume (ml),
                                                                                //Pure water tank capacity (ml), Pure water tank volume (ml), Salted water tank capacity (ml), Salted water tank volume (ml)
float cbV, air_temp;                                                            //Current beaker volume (ml), air temperature (celcius)
bool rfl_flag, htr_suspension, vol_state, sal_suspension;                       //Refill flag, heater suspension flag, state of mixture's volume

//Interrupt handlers
void refill() {
    rfl_flag = true;
}

void resume_operations() {
    htr_suspension = false;
    sal_suspension = false;
}

void change_volume() {
    char buf[6];
    pc.gets(buf, 6);                                                        //Get the extra/less volume
    cbV += (float) atoi(buf);                                                       //Apply the change in volume
    pc.printf("I recieved %s at the change volume function\n", buf);
    capacity_control();                                                     //Check for over/underflow  
}


//Initialization Functions
void set_bC() {
    char str[6];
    pc.gets(str, 6);                                                            //Get the extra/less volume
    bC = atoi(str);
    pc.printf("Mbed received beaker's capacity: %d ml\n", bC);
}

void set_cbV() {
    char str[6];
    pc.gets(str, 6);
    cbV = atof(str);
    pc.printf("Mbed received current beaker's volume: %.3f ml\n", cbV);
}
 
void set_pwTC() {
    char str[6];
    pc.gets(str, 6);
    pwTC = atoi(str);
    pc.printf("Mbed received pure water tank's capacity: %d ml\n", pwTC);
}
 
void set_pwTV() {                                                                    //Set pure water tank volume 
    char str[6];
    pc.gets(str, 6);
    pwTV = atoi(str);
    pc.printf("Mbed received pure water tank's volume: %d ml\n", pwTV);
 
}
 
void set_swTC() {
    char str[6];
    pc.gets(str, 6);
    swTC = atoi(str);
    pc.printf("Mbed received pure water tank's capacity: %d ml\n", swTC);
}
 
void set_swTV() {
   char str[6];
    pc.gets(str, 6);
    swTV = atoi(str);
    pc.printf("Mbed received pure water tank's volume: %d ml\n", swTV);
}


void initialization() {
    buzzer = 0;                                                                 //Silence buzzer
    pw_csv = SDC;                                                               //Syringes start with 25ml deploying water capacity
    sw_csv = SDC;
    vol_state=true;                                                             //Assume normal starting state
    rfl_flag = false;                                                           //Not refilling atm
    htr_suspension = false;                                                     //No heater suspension
    sal_suspension = false;                                                     //No salinity operations suspended
    rfl_swt.rise(&refill);                                                      //Attach refill switch to respective function
    rsm_htr.rise(&resume_operations);                                           //Attach resume operations
    set_bC();                                                                   //Set the beaker capacity
    set_cbV();                                                                  //Set current beaker volume
    set_pwTC();                                                                 //Set pure water tank capacity
    set_pwTV();                                                                 //Set pure water tank volume
    set_swTC();                                                                 //Set salted water tank capacity
    set_swTV();                                                                 //Set salted water tank volume
    air_temp = take_air_temp();
    pc.printf("air temp = %.3f\n", air_temp);
    pc.attach(change_volume);                                                   //extra/less volume in the beaker
    pc.printf("Initialization completed!\n");
}

void normality_test(bool sal_state, bool temp_state){
    if (sal_state && temp_state && vol_state) {led1=1; led2=0; pc.printf("Normal operation\n");}
    else {led1=0; led2=1;}     
}

void danger() {
    led2 = 1; //switch the led on, by setting the output to logic 1
    wait(0.1); //wait 0.2 seconds
    led2 = 0; //switch the led off
    wait(0.1);
    buzzer = 1;
    wait(0.1);
    buzzer = 0; 
    wait(0.1);
}

void capacity_control() {
    if (cbV > bC*BHC) {
        lcd.cls();
        lcd.printf("CBV > 80%% Cap.");
        lcd.printf("\nAbort operation!");
        while(1) {
            pc.printf("Overflow danger! Current Beaker Volume over 80%% capacity!\nABORT OPERATION!");
            danger();
        }
    }
    if (cbV < bC*BLC) {
        lcd.cls();
        lcd.printf("CBV < 20%% Cap.");
        lcd.printf("\nAbort operation!");
        while(1) {
            pc.printf("Underflow danger! Current Beaker Volume under 20%% capacity!\nABORT OPERATION!");
            danger();   
        }     
    }
    pc.printf("Everythink OK with capacity control\n");
}