#include "calibration.h"
#include "DRV8825.h"
#include "motors.h"
 
extern Serial pc;
extern DRV8825 stpr_mtr1;
extern DRV8825 stpr_mtr2;
 
void calibrate(char motor, char* direction){
    int i,j, dir;
    pc.printf("Direction = %s\n", (strcmp(direction,"left")==0)?"left":"right");
    pc.printf("Motor = %c\n", motor=='a' ? 'a':'b');
    if((strcmp(direction,"right")==0 && motor=='a') || (strcmp(direction,"left")==0 && motor=='b')) dir=1; else dir=0;
    for(j=0; j<200; j++) {                           //500 rotations
        for (i = 500; i < MAX_SPEED; i+=100) {
            if (motor=='a') stpr_mtr1.settings(1, dir, i);
            else stpr_mtr2.settings(1, dir, i);
        }
    }
}
 
void test_interrupts() {
    
}
 
 
