#include "mbed.h"

LocalFileSystem local("local");

//決定|済|r|9|8|7|6|5|4|3|2|1|可能性個数[1]|可能性個数[2]|可能性個数[3]|可能性個数[4]

int main(){
    unsigned short num[9][9];
    unsigned short carrier;
    char As,Ae,Bs,Be,Xs,Xe,Ys,Ye;
    bool flag=true;
    bool second=true;
    unsigned short ckA,ckB,ckC;
    char COUNT=81;
    bool err=false;
    printf("NEW\n");
    
    //ファイル読み込み
    FILE* fp = fopen("/local/num.txt","r");
    for(char g=0;g<9;g++){
        fscanf(fp,"%u\t%u\t%u\t%u\t%u\t%u\t%u\t%u\t%u",&num[g][0],&num[g][1],&num[g][2],&num[g][3],&num[g][4],&num[g][5],&num[g][6],&num[g][7],&num[g][8]);
        for(char k=0;k<9;k++){
            printf("%u",num[g][k]);
            }
        printf("\n");
            
        //ビット構成
        for(char v=0;v<9;v++){
            if(num[g][v]==0){
                num[g][v]=0x1FF9;
                }else{
                switch(num[g][v]){
                    case 1 : num[g][v] = 0x8011;break;
                    case 2 : num[g][v] = 0x8021;break;
                    case 3 : num[g][v] = 0x8041;break;
                    case 4 : num[g][v] = 0x8081;break;
                    case 5 : num[g][v] = 0x8101;break;
                    case 6 : num[g][v] = 0x8201;break;
                    case 7 : num[g][v] = 0x8401;break;
                    case 8 : num[g][v] = 0x8801;break;
                    case 9 : num[g][v] = 0x9001;break;
                    default: num[g][v] = 0x1FF9;printf("INPUT ERROR : num[%u][%u]\n",g,v);err=true;break;
                    }
                }
            }
        }
    fclose(fp);
    /*
    //デバッグ用///////////////////////////////
    printf("\n");
    for(char G=0;G<9;G++){
        for(char K=0;K<9;K++){
            printf("%x",(num[G][K] >> 14));
            }
        printf("\n");
        }
    printf("\n");
    for(char G=0;G<9;G++){
        for(char K=0;K<9;K++){
            printf("%x",(num[G][K] & 0x000F));
            }
        printf("\n");
        }
    //////////////////////////////////////////
    */
    printf("START\n");
//決定|済|r|9|8|7|6|5|4|3|2|1|可能性個数[1]|可能性個数[2]|可能性個数[3]|可能性個数[4]
    //計算
    while(flag){
        flag=false;
        for(char i=0;i<9;i++){
            for(char j=0;j<9;j++){
                if((num[i][j] & 0x000F) == 0x0001){
                    num[i][j] = num[i][j] | 0x8000;//if()内は(...&...)として括弧をつけないとコンパイルミスする。
                    }
                if((num[i][j] & 0x8000) == 0x8000 && (num[i][j] & 0x4000) != 0x4000){
                    flag=true;
                    COUNT--;
                    if(second==false)second=true;
                    for(char a=0;a<9;a++){
                        if(a!=i){
                            carrier = num[a][j];
                            num[a][j] = num[a][j] & (~(num[i][j] & 0x1FF0));
                            if(carrier != num[a][j])num[a][j]--;
                            }
                        }
                    for(char b=0;b<9;b++){
                        if(b!=j){
                            carrier = num[i][b];
                            num[i][b] = num[i][b] & (~(num[i][j] & 0x1FF0));
                            if(carrier != num[i][b])num[i][b]--;
                            }
                        }
                    if(i<=2)     {As=0;Ae=2;}
                    else if(i>=6){As=6;Ae=8;}
                    else         {As=3;Ae=5;}
                    if(j<=2)     {Bs=0;Be=2;}
                    else if(j>=6){Bs=6;Be=8;}
                    else         {Bs=3;Be=5;}
                    for(char s=As;s<=Ae;s++){
                        for(char t=Bs;t<=Be;t++){
                            if((s!=i) || (t!=j)){
                                carrier = num[s][t];
                                num[s][t] = num[s][t] & (~(num[i][j] & 0x1FF0));
                                if(carrier != num[s][t])num[s][t]--;
                                }
                            }
                        }
                    num[i][j] = num[i][j] | 0x4000;
                    }
                }
            }
        for(char c=0;c<9;c++){
            switch(c){
                case 0 : Xs=0;Xe=2;Ys=0;Ye=2;break;
                case 1 : Xs=0;Xe=2;Ys=3;Ye=5;break;
                case 2 : Xs=0;Xe=2;Ys=6;Ye=8;break;
                case 3 : Xs=3;Xe=5;Ys=0;Ye=2;break;
                case 4 : Xs=3;Xe=5;Ys=3;Ye=5;break;
                case 5 : Xs=3;Xe=5;Ys=6;Ye=8;break;
                case 6 : Xs=6;Xe=8;Ys=0;Ye=2;break;
                case 7 : Xs=6;Xe=8;Ys=3;Ye=5;break;
                case 8 : Xs=6;Xe=8;Ys=6;Ye=8;break;
                }
            ckA=0;ckB=0;ckC=0;
            for(char x=Xs;x<=Xe;x++){
                for(char y=Ys;y<=Ye;y++){
                    if((num[x][y] & 0x8000)!= 0x8000){
                        ckA = ckA | (ckB & (num[x][y] & 0x1FF0));//複数存在する候補
                        ckB = ckB | (num[x][y] & 0x1FF0);//存在する候補
                        }
                    }
                }
            ckC = ckB & ~ckA;
            //printf("%d,%d,%x,%x,%x\n",Xs/3,Ys/3,ckA,ckB,ckC);
            if(ckC != 0x0000){
                for(char X=Xs;X<=Xe;X++){
                    for(char Y=Ys;Y<=Ye;Y++){
                        if(((num[X][Y] & ckC) & 0x1FF0) != 0){
                            num[X][Y] = (num[X][Y] & ckC) | 0x0001;
                            flag=true;
                            if(second==false)second=true;
                            }
                        }
                    }
                }
            }
        if(second==false && flag==false)printf("STOP\n");
        if(second==true && flag==false){
            second=false;
            flag=true;
            }
    /*
    //デバッグ用///////////////////////////////
    printf("\n");
    for(char G=0;G<9;G++){
        for(char K=0;K<9;K++){
            printf("%x",(num[G][K] >> 14));
            }
        printf("\n");
        }
    printf("\n");
    for(char G=0;G<9;G++){
        for(char K=0;K<9;K++){
            printf("%x",(num[G][K] & 0x000F));
            }
        printf("\n");
        }
    printf("%x,%x,%x\n",num[3][0],num[3][2],num[5][1]);
    //////////////////////////////////////////
    */
        }

//決定|済|r|9|8|7|6|5|4|3|2|1|可能性個数[1]|可能性個数[2]|可能性個数[3]|可能性個数[4]
    //数値化
    for(char n=0;n<9;n++){
        for(char m=0;m<9;m++){
            if(num[n][m] & 0x8000 == 0x8000){
                switch(num[n][m] & 0x1FF0){
                    case 0x0010 : num[n][m] = 1;break;
                    case 0x0020 : num[n][m] = 2;break;
                    case 0x0040 : num[n][m] = 3;break;
                    case 0x0080 : num[n][m] = 4;break;
                    case 0x0100 : num[n][m] = 5;break;
                    case 0x0200 : num[n][m] = 6;break;
                    case 0x0400 : num[n][m] = 7;break;
                    case 0x0800 : num[n][m] = 8;break;
                    case 0x1000 : num[n][m] = 9;break;
                    default     : num[n][m] = 10;printf("WRONG RESULT : num[%u][%u]\n",n,m);err=true;break;
                    }
                }else{
                num[n][m] = 0;
                }
            }
        }
    
    //ファイル書き込み
    FILE* fw = fopen("/local/result.csv","w");
    for(char h=0;h<9;h++){
        fprintf(fw,"%u,%u,%u,%u,%u,%u,%u,%u,%u\n",num[h][0],num[h][1],num[h][2],num[h][3],num[h][4],num[h][5],num[h][6],num[h][7],num[h][8]);
        }
    fclose(fw);
    if(COUNT!=0)err=true;
    if(err){
        printf("ERROR & END\n");
        }else{
        printf("END\n");
        for(char X=0;X<9;X++){
            for(char Y=0;Y<9;Y++){
                printf("%u",num[X][Y]);
                }
            printf("\n");
            }
        }
    }
