#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "TextLCD.h"
#include "DebouncedIn.h"

Rtc_Ds1307 rtc(PTE0, PTE1);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5);// rs, e, d4-d7
Serial pc(USBTX, USBRX, "pc");
DebouncedIn button1(PTC12); //Incremental
DebouncedIn button2(PTC13); //Decremental
DebouncedIn button3(PTC16); //Cambiador de variable
DebouncedIn button4(PTC17); //Configurador de modo
PwmOut pw(PTA12); //se define la salida del pwm para hacer sonar la bocina

//esta parte es para definir la frecuencia a la que suenan los botones
float Tdo=1/2093.005;
float Pdo=Tdo/2;
float Tre=1/2637.02;
float Pre=Tre/2;
float Tmi=1/3135.963;
float Pmi=Tmi/2;
float Tfa=1/4186.009;
float Pfa=Tfa/2;
//**********************************
int C1=0x0F; // comando para el lcd
//*************************************
int modo=0; //modo es para el boton 4. Indica: 0-mostrar datos, 1-configurar datos, 2-config alarma
int p=0; //p es el valor del boton 3 para la ubicación del modificador de variables 0-no aparece, 1-h, 2-m, 3-s, 4-D, 5-M, 6-Y.
//***************************************
//Definicion de variables para la configuración de alarma
int houral=2,minal=4,secal=0,dateal=8,monal=5,yearal=2014;
Timer t; // se define la variable t, contabilizadora del tiempo desde el inicio de la alarma
//*************************************
int main(){
    //Definiciones del ds1307
    Rtc_Ds1307::Time_rtc tm = {};
    rtc.startClock();
    //Comandos para la LCD
    lcd.cls(); //borrar pantalla
    lcd.writeCommand(C1);
//**************************************
    while(1) {   //Comienza el ciclo principal
        //PARTE PARA EL MODO 0: MUESTRA DE HORA Y FECHA
        if (modo==0) {
            while(modo==0) {  
                    rtc.getTime(tm);
                    lcd.locate(0,0); //las coordenadas van del 0 al 15 en la primera entrada, y de 0 a 1 en la segunda casilla
                    lcd.printf("Hora:%02d:%02d:%02d",tm.hour, tm.min, tm.sec); //%02d indica que la variable tiene maximo dos (2) digitos y si en algun caso solo tiene 1 digito,
                    lcd.locate(0,1);                         // el otro espacio que queda vacio debe llenarse con un cero (0)
                    lcd.printf("Fech:%02d/%02d/%04d", tm.date, tm.mon, tm.year);
                //Verificación de hora alarma
                if (tm.hour==houral && tm.min==minal && tm.sec==secal && tm.date==dateal && tm.mon==monal && tm.year==yearal) {
                     
                    while( button2==1) { // si el boton 2 se deja presionado sale del while lo que implica  que apaga la alarma
                   
                        pw.period(Tdo); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                        pw.pulsewidth(Pdo);
                        wait(0.5);
                        pw=0;
                        pw.period(Tre); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                        pw.pulsewidth(Pre);
                        wait(0.5);
                        pw=0;
                        pw.period(Tmi); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                        pw.pulsewidth(Pmi);
                        wait(0.5);
                        pw=0;
                        pw.period(Tfa); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                        pw.pulsewidth(Pfa);
                        wait(0.5);
                        pw=0; 
                         if(button1.falling() ==1) { // si dentro del while se produce una interrupción en el boton 1 retrasa la alarma 1 min
                        minal=minal+1;
                        pw=0;
                        } 
                    }
                    
    
                }   
                    
    
                if (button4.falling()) {
                    pw.period(Tfa); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                    pw.pulsewidth(Pfa);
                    wait(0.1);
                    pw=0;            
                    ++modo;
                    lcd.locate(0,0);
                    lcd.printf("Conf");
                }
            }
        }//fIN DEL MODO CERO 
        if (modo==1) {
            rtc.getTime(tm);
                while(modo==1){
                    if (button4.falling()) { //CAMBIADOR DE MODO
                        pw.period(Tfa); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                        pw.pulsewidth(Pfa);
                        wait(0.1);
                        pw=0;
                        ++modo;
                        lcd.locate(0,0); //las coordenadas van del 0 al 15 en la primera entrada, y de 0 a 1 en la segunda casilla
                        lcd.printf("Alrm:%02d:%02d:%02d",houral, minal, secal); //%02d indica que la variable tiene maximo dos (2) digitos y si en algun caso solo tiene 1 digito,
                        lcd.locate(0,1);                         // el otro espacio que queda vacio debe llenarse con un cero (0)
                        lcd.printf("Fech:%02d/%02d/%04d", dateal, monal, yearal); 
                    }
                    if (button1.falling()) { //INCREMENTAL
                        if (p==0) {pw=0;} //Condicion: incremental no suena si no estoy ubicado en una variable
                        else{
                            pw.period(Tdo); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                            pw.pulsewidth(Pdo);
                            wait(0.1);
                            pw=0;
                        }
                        if (p==1) { //posicion de variable hora
                            if (tm.hour==23) {
                                tm.hour=0;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", tm.hour);
                            } else {
                                ++tm.hour;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", tm.hour);
                            }
                         }
                         else if (p==2) { //p=2: posicion de variable minutos
                            if (tm.min==59) {
                                tm.min=0;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", tm.min);
                            } 
                            else {
                                ++tm.min;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", tm.min);
                            }
                        }
                         else if (p==3) {//p=3: posicion de variable segundos
                            if (tm.sec==59) {
                                tm.sec=0;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", tm.sec);
                            } 
                            else {
                                ++tm.sec;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", tm.sec);
                            }
                         }
                         else if (p==4) {//p=4: posicion de variable dia del mes
                             if (tm.date==31) {
                                 tm.date=1;
                                 lcd.locate(5,1);
                                 lcd.printf(" ");
                                 lcd.locate(5,1);
                                 lcd.printf("%02d", tm.date);
                             } 
                             else {
                                 ++tm.date;
                                 lcd.locate(5,1);
                                 lcd.printf(" ");
                                 lcd.locate(5,1);
                                 lcd.printf("%02d", tm.date);
                             }
                         } 
                         else if (p==5) {//p=5: posicion de variable mes
                             if (tm.mon==12) {
                                 tm.mon=1;
                                 lcd.locate(8,1);
                                 lcd.printf(" ");
                                 lcd.locate(8,1);
                                 lcd.printf("%02d", tm.mon);
                             } 
                             else {
                                 ++tm.mon;
                                 lcd.locate(8,1);
                                 lcd.printf(" ");
                                 lcd.locate(8,1);
                                 lcd.printf("%02d", tm.mon);
                             }
                        } 
                        else if (p==6) { //p=6: posicion de variable años
                            ++tm.year;
                            lcd.locate(11,1);
                            lcd.printf(" ");
                            lcd.locate(11,1);
                            lcd.printf("%04d", tm.year);
                        }
                    }
                    if (button2.falling()) { //boton decremental
                        if (p==0) {pw=0;} 
                        else{
                            pw.period(Tre);
                            pw.pulsewidth(Pre);
                            wait(0.1);
                            pw=0;
                        }
                        if (p==1) {
                            if (tm.hour==0) {
                                tm.hour=24;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", tm.hour);
                            } 
                            else {
                                --tm.hour;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", tm.hour);
                            }
                        }
                        else if (p==2) {
                            if (tm.min==0) { // no mostrar nada
                                tm.min=59;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", tm.min);
                            } 
                            else {
                                --tm.min;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", tm.min);
                            }
                        }
                        else if (p==3) {
                            if (tm.sec==0) { // no mostrar nada
                                tm.sec=59;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", tm.sec);
                            } 
                            else {
                                --tm.sec;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", tm.sec);
                            }
                        }
                        else if (p==4) {
                            if (tm.date==1) { // no mostrar nada
                                tm.date=31;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", tm.date);
                            } 
                            else {
                                --tm.date;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", tm.date);
                            }
                        }
                        else if (p==5) {
                            if (tm.mon==1) {
                                tm.mon=12;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", tm.mon);
                            } 
                            else {
                                --tm.mon;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", tm.mon);
                            }
                        }
                        else if (p==6) {
                            if (tm.year==2000) {
                                lcd.locate(11,1);
                                lcd.printf(" ");
                                lcd.locate(11,1);
                                lcd.printf("%04d", tm.year);
                            } 
                            else {
                                --tm.year;
                                lcd.locate(11,1);
                                lcd.printf(" ");
                                lcd.locate(11,1);
                                lcd.printf("%04d", tm.year);
                            }
                        }
                    }
                    if (button3.falling()) { //boton 3: cambiador de variable
                        pw.period(Tmi);
                        pw.pulsewidth(Pmi);
                        wait(0.1);
                        pw=0;
    
                        if (p==0) { //p=0: no esta parado en ninguna variable
                            ++p;
                            lcd.locate(5,0);
                            lcd.printf(" ");
                            lcd.locate(5,0);
                            lcd.printf("%02d", tm.hour);
                        } else if (p==1) { //p=1: ubicacion de variable hora
                            ++p;
                            lcd.locate(8,0);
                            lcd.printf(" ");
                            lcd.locate(8,0);
                            lcd.printf("%02d", tm.min);
                        } else if (p==2) {
                            ++p;
                            lcd.locate(11,0);
                            lcd.printf(" ");
                            lcd.locate(11,0);
                            lcd.printf("%02d", tm.sec);
                        } else if (p==3) {
                            ++p;
                            lcd.locate(5,1);
                            lcd.printf(" ");
                            lcd.locate(5,1);
                            lcd.printf("%02d", tm.date);
                        } else if (p==4) {
                            ++p;
                            lcd.locate(8,1);
                            lcd.printf(" ");
                            lcd.locate(8,1);
                            lcd.printf("%02d", tm.mon);
                        } else if (p==5) {
                            ++p;
                            lcd.locate(11,1);
                            lcd.printf(" ");
                            lcd.locate(11,1);
                            lcd.printf("%04d", tm.year);
                        } else if (p==6) {
                            p=0;
                            rtc.setTime(tm, true, false);//SOLO SI CONFIGURO TODAS LAS VARIOABLES Y RETORNO A P=0, LA HORA SE CONFIGURA
                        }
                    }
                }
            }
            //MODO 2: PROGRAMACION DE LA ALARMA
            if (modo==2) {
                rtc.getTime(tm);
                while(modo==2){
                    if (button1.falling()) {
                        if (p==0) {pw=0;} 
                        else{
                            pw.period(Tdo); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                            pw.pulsewidth(Pdo);
                            wait(0.1);
                            pw=0;
                        }
                        if (p==0) {
                        } else if (p==1) {
                            if (houral==23) {
                                houral=0;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", houral);
                            } else {
                                ++houral;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", houral);
                            }
                        } else if (p==2) {
                            if (minal==59) {
                                minal=0;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", minal);
                            } else {
                                ++minal;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", minal);
                            }
                        } else if (p==3) {
                            if (secal==59) {
                                secal=0;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", secal);
                            } else {
                                ++secal;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", secal);
                            }
                        } else if (p==4) {
                            if (dateal==31) {
                                dateal=1;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", dateal);
                            } else {
                                ++dateal;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", dateal);
                            }
                        } else if (p==5) {
                            if (monal==12) {
                                monal=1;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", monal);
                            } else {
                                ++monal;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", monal);
                            }
                        } else if (p==6) {
                            ++yearal;
                            lcd.locate(11,1);
                            lcd.printf(" ");
                            lcd.locate(11,1);
                            lcd.printf("%04d", yearal);
                        }
                    }
                    if (button2.falling()) {
                        if (p==0) {pw=0;} 
                        else{
                            pw.period(Tre);
                            pw.pulsewidth(Pre);
                            wait(0.1);
                            pw=0;
                        }
                        if (p==1) {
                            if (houral==0) { // no mostrar nada
                                houral=24;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", houral);
                            } else {
                                --houral;
                                lcd.locate(5,0);
                                lcd.printf(" ");
                                lcd.locate(5,0);
                                lcd.printf("%02d", houral);
                            }
                        }
                        if (p==2) {
                            if (minal==0) { // no mostrar nada
                                minal=59;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", minal);
                            } else {
                                --minal;
                                lcd.locate(8,0);
                                lcd.printf(" ");
                                lcd.locate(8,0);
                                lcd.printf("%02d", minal);
                            }
                        }
                        if (p==3) {
                            if (secal==0) { // no mostrar nada
                                secal=59;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", secal);
                            } else {
                                --secal;
                                lcd.locate(11,0);
                                lcd.printf(" ");
                                lcd.locate(11,0);
                                lcd.printf("%02d", secal);
                            }
                        }
                        if (p==4) {
                            if (dateal==1) { // no mostrar nada
                                dateal=31;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", dateal);
                            } else {
                                --dateal;
                                lcd.locate(5,1);
                                lcd.printf(" ");
                                lcd.locate(5,1);
                                lcd.printf("%02d", dateal);
                            }
                        }
                        if (p==5) {
                            if (monal==1) {
                                monal=12;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", monal);
                            } else {
                                --monal;
                                lcd.locate(8,1);
                                lcd.printf(" ");
                                lcd.locate(8,1);
                                lcd.printf("%02d", monal);
                            }
                        }
                        if (p==6) {
                            if (yearal==2000) {
                                lcd.locate(11,1);
                                lcd.printf(" ");
                                lcd.locate(11,1);
                                lcd.printf("%04d", yearal);
                            } else {
                                --yearal;
                                lcd.locate(11,1);
                                lcd.printf(" ");
                                lcd.locate(11,1);
                                lcd.printf("%04d", yearal);
                            }
                        }
                    }
                    if (button3.falling()) {//BOTON 3: CAMBIADOR DE VARIABLE (POSICION EN LA LCD)    
                        pw.period(Tmi);
                        pw.pulsewidth(Pmi);
                        wait(0.1);
                        pw=0;
    
                        if (p==0) {
                            ++p;
                            lcd.locate(5,0);
                            lcd.printf(" ");
                            lcd.locate(5,0);
                            lcd.printf("%02d", houral);
                        } else if (p==1) {
                            ++p;
                            lcd.locate(8,0);
                            lcd.printf(" ");
                            lcd.locate(8,0);
                            lcd.printf("%02d", minal);
                        } else if (p==2) {
                            ++p;
                            lcd.locate(11,0);
                            lcd.printf(" ");
                            lcd.locate(11,0);
                            lcd.printf("%02d", secal);
                        } else if (p==3) {
                            ++p;
                            lcd.locate(5,1);
                            lcd.printf(" ");
                            lcd.locate(5,1);
                            lcd.printf("%02d", dateal);
                        } else if (p==4) {
                            ++p;
                            lcd.locate(8,1);
                            lcd.printf(" ");
                            lcd.locate(8,1);
                            lcd.printf("%02d", monal);
                        } else if (p==5) {
                            ++p;
                            lcd.locate(11,1);
                            lcd.printf(" ");
                            lcd.locate(11,1);
                            lcd.printf("%04d", yearal);
                        } else if (p==6) {
                            p=0;
                        }
                    }    
                    if (button4.falling()) { //BOTON 4: CAMBIADOR DE MODO
                            pw.period(Tfa); // aqui se indica la frecuencia para el sonido al pulsar el boton 1
                            pw.pulsewidth(Pfa);
                            wait(0.1);
                            pw=0;  
                            modo=0;
                            lcd.locate(0,0);
                            lcd.printf("Hora");
                    }
                }
              }
            }       
    
}
