#include "mbed.h"
#include "TextLCD.h"
#include "DebouncedIn.h"
#include "QEI.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5);  //configura los puestos PTE0,PTE1,PTE2,PTE3,PTE4,PTE5, donde se conectara el LCD 16x2
QEI conteo(PTA13,PTD5,NC,12);
DebouncedIn salto(PTC16);
DebouncedIn set(PTC17);
AnalogIn Vin(PTB0);
AnalogOut Vout(PTE30);
PwmOut pw(PTA12);
float Tdo=1/2093.005;
float Pdo=Tdo/2;
float Tre=1/2637.02;
float Pre=Tre/2;
float Tmi=1/3135.963;
float Pmi=Tmi/2;
Timer t;
int flag;
int q;
int C1=0x0E;    //configurar el lcd para mostrar el guin bajo
int C2=0x0C;    //configurar el lcd para no mostrar el guion bajo
int s=0;       //set point
int p=0;       //ganancia proporcional
int i=0;       //ganancia integral
int d=0;       //ganancia derivativa
int k=0;       //variable de control}
int err, med, yr, ap, ai, ad, err_v, cycle;
int pid;
int viejo=0;
int cont=0;

void def_posicion(int h){
    if (h==0){
    lcd.locate(3,0); lcd.printf("%d",s);
    lcd.locate(3,0); 
    }
    else if(h==1){
    lcd.locate(11,0);   lcd.printf("%d",p);
    lcd.locate(11,0);   
    }
    else if (h==2){
    lcd.locate(3,1); lcd.printf("%d",i);
    lcd.locate(3,1); 
    }
    else {
    lcd.locate(11,1);   lcd.printf("%d",d);
    lcd.locate(11,1);  
    }
    }


void incremento (int r) {            //Funcion que incremente los valores 
if(k==0){
        s+=r;
        if(s<=0){
        s=0;
        }
        else if (s>=999){
        s=999;
        }
        lcd.locate(3,0);            
        lcd.printf("%d ",s);
      }
else if(k==1){
        p+=r;
        if(p<=0){
        p=0;
        }
        else if (p>=999){
        p=999;
        }
        lcd.locate(11,0);            
        lcd.printf("%d ",p);
      }
else if(k==2){
        i+=r;
        if(i<=0){
        i=0;
        }
        else if (i>=999){
        i=999;
        }
        lcd.locate(3,1);            
        lcd.printf("%d ",i);  
      }
else{
        d+=r;
        if(d<=0){
        d=0;
        }
        else if (d>=999){
        d=999;
        }
        lcd.locate(11,1);            
        lcd.printf("%d ",d);
    }
 }
 
 
void star_patch1(void){  //funcion que imprime los caracteres que no van a variar en el display
lcd.cls();
lcd.locate(8,0);
lcd.printf("Kp=%d",p);
lcd.locate(0,1);
lcd.printf("Ki=%d",i);
lcd.locate(8,1);
lcd.printf("Kd=%d",d);
lcd.writeCommand(C1);   //permite que el cursor se vea y sea intermitente
lcd.locate(0,0); 
lcd.printf("Sp=%d",s);
}

void star_patch2(void){  //funcion que imprime los caracteres que no van a variar en el display
lcd.writeCommand(C2);
lcd.cls();
lcd.printf("***INICIA PID***");    lcd.printf("***************");
wait(2);
lcd.cls();
lcd.printf("Er%=d",err);
lcd.locate(8,0);    lcd.printf("Me=%d",med); 
lcd.locate(0,1);    lcd.printf("Sp=%d",s);
lcd.locate(8,1);    lcd.printf("Co=%d",pid);
wait(3);
}

int main(){
star_patch1();
viejo=0;
cont=0;
while(1){
    if(k>=3 && salto.falling()){
    k=0; 
     pw.period(Tdo);
            pw.pulsewidth(Pdo);
            wait(0.1);
            pw=0;   
    def_posicion(k);
    }  
    if(salto.falling()){  
    ++k;
     pw.period(Tdo);
            pw.pulsewidth(Pdo);
            wait(0.1);
            pw=0;
    def_posicion(k);
    }
    else if(set.falling()){
        break;
    }
    viejo=conteo.getPulses()-cont;
    cont=conteo.getPulses();
    if(viejo==0){
    //no hace nada
    }
    else {
    incremento(viejo);
    }}
    
star_patch2();

while (1){

med=Vin.read()*1000;
err = (s-med);
ap = k*err;           
ai =(i*err)+ai;    //calculo de la integral del error
// se verifica que la accion integral no sea muy grande
ad = d*(err-err_v); //calculo de la accion derivativa
pid = (ap+ai+ad);
//****se muestran las variables******************************************
if (pid > 999){
pid=1000;
} 
else if (pid<0){
pid=0;
}
Vout.write(pid/1000);
if(flag==0){
t.start();
flag=1;
}
if (t>0.3){
lcd.locate(3,0);
lcd.printf("     ");
lcd.locate(3,0);
lcd.printf("%d",err);
lcd.locate(11,0);
lcd.printf("     ");
lcd.locate(11,0);
lcd.printf("%d",med);
lcd.locate(3,1);
lcd.printf("     ");
lcd.locate(3,1);
lcd.printf("%d",s);
lcd.locate(11,1);
lcd.printf("     ");
lcd.locate(11,1);
lcd.printf("%d ",pid);
t.reset();
flag=0;
wait(.1);
}
// se actualizan las variables *******************************************
err_v = err;
}
}