#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"

#ifdef TARGET_WIZWIKI_W7500
    SDFileSystem local(SD_MOSI, SD_MISO, SD_CLK, SD_SEL, "local");//PB_3, PB_2, PB_1, PB_0
#else
    LocalFileSystem local("local");
    //or TODO:
#endif

#ifdef TARGET_WIZWIKI_W7500
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};
#endif

EthernetInterface eth;
HTTPServer  svr;
char ip_addr[] = "192.168.1.111";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.1.1";

//#define DHCP //If uncomment, W7500 runs DHCP

int main()
{
    printf("Wait a second...\r\n");
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");

#ifdef TARGET_WIZWIKI_W7500
    
    #ifdef DHCP
        eth.init(mac_addr); //Use DHCP
    #else
        eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif

#else

    #ifdef DHCP
        eth.init(); //Use DHCP
    #else
        eth.init(ip_addr, subnet_mask, gateway_addr); //Not Use DHCP
    #endif

#endif



    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());

    if (!svr.start(80, &eth)) {

        error("Server not starting !");
        exit(0);
    }

    while(1) {
        svr.poll();
    }
    
}

