#include "mbed.h"
#include "HTTPClient.h"

#ifdef TARGET_LPC11U68
#include "WIZnetInterface.h"
#endif

#if defined(TARGET_WIZWIKI_W7500)
#include "EthernetInterface.h"
#endif

#define USE_DHCP    0

const char * IP_Addr    = "IP Address";
const char * IP_Subnet  = "IP Subnet";
const char * IP_Gateway = "IP Gateway";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

Serial pc(USBTX, USBRX);

#ifdef TARGET_LPC11U68
SPI spi(P0_9,P0_8,P1_29);
WIZnetInterface ethernet(&spi,P0_2,P1_13);
AnalogIn CDSSensor(P1_9);//Analog A0 input. pgm5537 CDS sensor and 10k resistor.
/******************
VCC     A0      GND
 |      |       |
 |      |       |
 |      |       |
 |      |       |
 --10k-----CDS---
*******************/
#endif

#if defined(TARGET_WIZWIKI_W7500)
EthernetInterface ethernet;
Serial pc(USBTX, USBRX);
AnalogIn CDSSensor(PC_15);//Analog A0 input. pgm5537 CDS sensor and 10k resistor.
#endif


int main() {

    mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    pc.baud(115200);
    #if USE_DHCP
    int ret = ethernet.init(MAC_Addr);
    #else
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    if (!ret) {
        pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            exit(0);
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        exit(0);
    }
    
    char str[512] = "";
    char get_msg[128]= "";
    
    /*
        http://dweet.io/follow/nameYouWant
    */
    char nameYouWant[] = "nameYouWant";
    while(1)
    {
        sprintf(get_msg,"http://dweet.io/dweet/for/%s?a0=%d",nameYouWant,(int)(CDSSensor.read()*1000));
        HTTPClient http;
        
        pc.printf("Send post message to dweet.io\r\n");
        pc.printf("msg : %s\r\n",get_msg);
        ret = http.get(get_msg, str, sizeof(str));
        if(!ret)
        {
          pc.printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
          pc.printf("Result: %s\r\n", str);
        }
        else
        {
          pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
        wait(10);
    }
   
}
