/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "TCPSocket.h"
#include "mbed.h"
#include "WizFi310Interface.h"

#if defined(TARGET_WIZwiki_W7500)
    WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);
    Serial pc(USBTX,USBRX);
#endif

#define AP_SSID     "SSID"
#define AP_PASSWORD "PASS"
#define AP_SECURITY NSAPI_SECURITY_WPA2

#define CITY        "Seoul"
#define API_KEY     "API KEY"

int main()
{
    int errConnect;
    char http_cmd[1000] = "";
    char buffer[2048] = "";
    
    pc.baud(115200);
    printf("WizFi310 NetworkSocketAPI TCP Client OpenWeatherMap Example\r\n");
    
    wifi.connect(AP_SSID, AP_PASSWORD, AP_SECURITY);
    
    const char *ip = wifi.get_ip_address();
    const char *mac = wifi.get_mac_address();
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
    printf("MAC address is: %s\r\n", mac ? mac : "No MAC");

    SocketAddress addr(&wifi, "api.openweathermap.org");
    printf("api.openweathermap.org resolved to: %s\r\n", addr.get_ip_address());
           
    TCPSocket socket(&wifi);
    socket.set_timeout(1000);   //Set Block Mode.
    errConnect = socket.connect("api.openweathermap.org", 80);
    
    while (true) {
        if(errConnect!=0) {
            printf("\r\ncould not connect to socket : error = %d\r\n", errConnect);
            errConnect = socket.connect("api.openweathermap.org", 80);
        } else {
            printf("socket connected\r\n");
            break;
        }
    }    
     
    sprintf((char *)http_cmd,"GET /data/2.5/weather?q=%s&appid=%s HTTP/1.0\r\nHost: api.openweathermap.org\r\nConnection: close\r\n\r\n",
    CITY, API_KEY);

    socket.send(http_cmd, sizeof(http_cmd));
    
    socket.recv(buffer, sizeof(buffer));
    printf("%s\r\n",buffer);
 
    socket.close();
    wifi.disconnect();
    
    printf("Done\r\n");

}

