/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include <stdio.h>
#include "mbed.h"
#include "WizFi310Interface.h"

#define SECURE WizFi310::SEC_AUTO
#define SSID        "SSID"
#define PASS        "PASS"

#define VARID_LUX   "Ubidots Variable ID"
#define TOKEN       "Ubidots Token value"

#if defined(TARGET_WIZwiki_W7500)
    WizFi310Interface wizfi310(D1, D0, D7, D6, D9, NC, 115200);
    Serial pc(USBTX, USBRX);
    AnalogIn myLux(PC_15);
#endif


int main()
{
    int errConnect;
    char str[50] = "";
    char http_cmd[1000] = "";
    char buffer[2048] = "";  
    
    pc.baud(115200);
    printf("WizFi310 NetworkSocketAPI TCP Client Ubidots Example\r\n");
            
    wizfi310.init();
    if( wizfi310.connect(SECURE, SSID, PASS) )    return -1;
    
    const char *ip = wizfi310.getIPAddress();
    const char *mac = wizfi310.getMACAddress();
    //printf("IP address is: %s\r\n", ip ? ip : "No IP");
    //printf("MAC address is: %s\r\n", mac ? mac : "No MAC");

    TCPSocketConnection socket;
    socket.set_blocking(1000);   // Set Block Mode.
    errConnect = socket.connect("things.ubidots.com", 80);
    
    while (true) {
        if(errConnect!=0) {
            printf("\r\ncould not connect to socket : error = %d\r\n", errConnect);
            errConnect = socket.connect("things.ubidots.com", 80);
        } else {
            printf("socket connected\r\n");
            break;
        }
    }
            
    sprintf((char *)str, "{\"value\": %d}", (int)(myLux.read()*10000));
    printf("%s\r\n", str);
    int len = strlen((char *)str);
    
    sprintf((char *)http_cmd,"POST /api/v1.6/variables/%s/values HTTP/1.1\r\nContent-Type: application/json\r\nContent-Length: %d\r\nX-Auth-Token: %s\r\nHost: things.ubidots.com\r\n\r\n%s\r\n\r\n",
    VARID_LUX,len, TOKEN, str);

    socket.send_all((char *)http_cmd, strlen((char *)http_cmd));
    
    socket.receive(buffer, strlen((char *)buffer));
    printf("%d\r\n",strlen((char *)buffer));
    wait(5);
    
    socket.close();
    wizfi310.disconnect();
    
    printf("Done\r\n");
}

