/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "WizFi310Interface.h"


#if defined(TARGET_NUCLEO_F411RE)
Serial pc(USBTX, USBRX);
WizFi310Internet wifi(PA_11, PA_12, D6, D7, D3, NC, 115200);
#endif

#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
WizFi310Interface wizfi310(D1, D0, D7, D6, D8, NC, 115200);
#endif

#define SECURE WizFi310::SEC_AUTO
#define SSID "wizms1"
#define PASS "maker0701"

int main()
{
    pc.baud(115200);
    printf("WizFi310 NetworkSocketAPI TCP Client Example\r\n");
    wizfi310.init();
    wizfi310.connect(SECURE, SSID, PASS);
    
    const char *ip = wizfi310.getIPAddress();
    const char *mac = wizfi310.getMACAddress();
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
    printf("MAC address is: %s\r\n", mac ? mac : "No MAC");

    Endpoint addr;
    addr.set_address("mbed.org", 80);
    printf("mbed.org resolved to: %s\r\n", addr.get_address());
    
    TCPSocketConnection socket;
    socket.connect("4.ifcfg.me", 23);
 
    char buffer[64];
    int count = socket.receive(buffer, sizeof(buffer));
    printf("public IP address is: %.15s\r\n", &buffer[15]);
    
    socket.close();
    wizfi310.disconnect();
    
    printf("Done\r\n");

}