/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "TCPSocket.h"
#include "mbed.h"
#include "WizFi310Interface.h"
#include "TCPSocket.h"

#if defined(TARGET_NUCLEO_F411RE)
Serial pc(USBTX, USBRX);
WizFi310Internet wifi(PA_11, PA_12, D6, D7, D3, NC, 115200);
#endif

#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);
#endif

#define AP_SSID "wizms1"
#define AP_PASSWORD "maker0701"
#define AP_SECURITY NSAPI_SECURITY_WPA2

int main()
{
    pc.baud(115200);
    printf("WizFi310 NetworkSocketAPI TCP Client Example\r\n");
    
    wifi.connect(AP_SSID, AP_PASSWORD, AP_SECURITY);
    
    const char *ip = wifi.get_ip_address();
    const char *mac = wifi.get_mac_address();
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
    printf("MAC address is: %s\r\n", mac ? mac : "No MAC");

    SocketAddress addr(&wifi, "mbed.org", 80);
    printf("mbed.org resolved to: %s\r\n", addr.get_ip_address());
    
    TCPSocket socket(&wifi);
    socket.connect("4.ifcfg.me", 23);
 
    char buffer[64];
    int count = socket.recv(buffer, sizeof buffer);
    printf("public IP address is: %.15s\r\n", &buffer[15]);
    
    socket.close();
    wifi.disconnect();
    
    printf("Done\r\n");

}