/*
 * Copyright (C) 2015 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "WizFi310Interface.h"



#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
WizFi310Interface wifi(D1, D0, D7, D6, D9, NC, 115200);
#endif

#define AP_SSID "<SSID>" // Input SSID
#define AP_PASSWORD "<PW>" // Input PW

#define AP_SECURITY NSAPI_SECURITY_WPA2

/**
 *  \brief Hello World
 *  \param none
 *  \return int
 */
int main()
{
    pc.baud(115200);
    printf("WizFi310 Hello World demo. \r\n");
    if ( wifi.connectAP(AP_SSID, AP_PASSWORD, AP_SECURITY))      return -1; // AP mode
    printf("IP Address is %s\r\n", wifi.get_ip_address());
    
    while(1);
    
    wifi.disconnect();
}