/*
 /* Copyright (C) 2014 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "WizFi250Interface.h"


#define SECURE WizFi250::SEC_AUTO
#define SSID "DIR-815_Wiznet"
#define PASS "12345678"

#define ECHO_SERVER_ADDRESS "192.168.18.105"
#define ECHO_SERVER_PORT    5000

#if defined(TARGET_FRDM_KL25Z)
    WizFi250Interface wizfi250(PTE0,PTE1,PTD5,PTD0,PTD4,NC,115200);
#elif defined(TARGET_WIZwiki_W7500)
    WizFi250Interface wizfi250(D0,D1,D7,D8,PA_12,NC,115200);
    Serial pc(USBTX, USBRX);
#endif



void testUdpEchoClient();
void testUdpEchoServer();
void testTcpEchoClient();
void testTcpEchoServer();

int main()
{
    char input;
    
    pc.baud(115200);
    
    wizfi250.init();
    if ( wizfi250.connect(SECURE, SSID, PASS))      return -1;
    printf("IP Address is %s\r\n", wizfi250.getIPAddress());
    
    
    while(1)
    {
        printf("\r\nInput Test Mode ( 1:)\r\n");
        input = pc.getc();
    
        if(input == 'q')
            break;
    
        switch(input)
        {
        case '1':
            testTcpEchoServer();
            break;
        case '2':
            testTcpEchoClient();
            break;
        case '3':
            testUdpEchoClient();
            break;
        case '4':
            testUdpEchoServer();
            break;
        default:
            break;        
        }
    }
    
    printf("End the test program\r\n");
}


void testTcpEchoServer()
{
    char buffer[1024];
    int n = 0;

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    printf("\nWait for new connection...\r\n");
    TCPSocketConnection client;
    server.accept(client);
    client.set_blocking(false, 1500);

    printf("Connection from: %s\r\n", client.get_address());
    while (true)
    {
        if( client.is_connected() == false )
        {
            client.close();
            server.close();
            break;
        }
        n = client.receive_all(buffer, sizeof(buffer));
        if ( n > 0 )
        {
            buffer[n] = '\0';
            printf("length : %d\r\n", n);

            client.send_all(buffer, n);
        }
    }
}

void testUdpEchoClient()
{
    int i;
    UDPSocket sock;
    sock.init();

    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);


    for(i=0;i<10;i++)
    {
        char out_buffer[] = "Hello World\n";
        sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));

        char in_buffer[256];
        int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));
        in_buffer[n] = '\0';

        if( n > 0 )
            printf("%s\r\n", in_buffer);
    }

    sock.close();
}


void testUdpEchoServer()
{
        UDPSocket server;
        server.set_blocking(false);
        server.bind(ECHO_SERVER_PORT);

        Endpoint client;
        char buffer[256];
        while(true)
        {
            int n = server.receiveFrom(client, buffer, sizeof(buffer));
            if(n > 0)
            {
                //INFO("Received packet from: %s\n", client.get_address());
                buffer[n] = '\0';
                printf("%s\r\n", buffer);
                server.sendTo(client, buffer, n);
                break;
            }
        }
}


void testTcpEchoClient()
{
    char buffer[512];
    TCPSocketConnection socket;

    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0)
    {
        printf("Unable to connect to (%s) on port (%d)\r\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }

    while(true)
    {
        int n = socket.receive(buffer, sizeof(buffer));
        if(n > 0)
        {
            buffer[n] = '\0';
            printf("%s\r\n",buffer);
            socket.send(buffer, strlen(buffer));
            //socket.send_all(buffer, sizeof(buffer)-1);
            break;
        }
    }

    socket.close();
}
