#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "WizFi250Interface.h"
#include "NTPClient.h"
#include "HTTPClient.h"
 

#define SECURE WizFi250::SEC_AUTO
#define SSID "DIR-815_Wiznet"
#define PASS "12345678"


#if defined(TARGET_WIZwiki_W7500)
//    #define SDA                  PA_10
//    #define SCL                  PA_9
    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    Serial pc(USBTX,USBRX);
#endif


// an SPI sub-class that provides a constructed default
//class I2CPreInit : public I2C
//{
//public:
//    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
//    {
//        frequency(100000);
//        start();
//    };
//};

//I2CPreInit gI2C(SDA,SCL);
//Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
NTPClient ntpClient;
HTTPClient httpClient;
void parse(char buffer[], int *j, char *string); //FUNCTION TO PARSE HTTP GET DATA
char httpGetData[1024]; //BUFFER TO HOLD DATA FROM HTTP GET REQUEST


int main()
{
    time_t ctTime; //system time structure
    char success[10]={0};  //success first
    char countryFull[20]={0}; //Full Country Name
    char countryAbrv[5]={0}; //Abbreviated Country Name or country Code
    char stateAbrv[5]={0}; //Abbreviated State or region code
    char stateFull[15]={0}; //Full State Name
    char city[15]={0}; //City Name
    char zip[6]={0}; //ZIP CODE
    char latitude[10]={0}; //latitude
    char longitude[10]={0}; //longitude
    char timeZone[30]={0}; //timeZone
    int j=0, returnCode;

    pc.baud(115200);
//    gOled.begin();
//    gOled.clearDisplay();

    wizfi250.init();
    returnCode = wizfi250.connect(SECURE, SSID, PASS);

    if ( returnCode == 0 )
    {
        printf(" - WiFi Ready\r\n");
        printf("IP Address is %s\r\n", wizfi250.getIPAddress());
    }
    else
    {
        printf(" - Could not initialize WiFi - ending\r\n");
        return 0;
    }
    
    //HANDLES THE HTTP GET REQUEST THE WAY THE FUNCTION IS CALLED HERE IS THE FOLLOWING
    // get(DOMAIN_NAME,BUFFER,TIMEOUT_VAL)
    //DOMAIN_NAME= domain name that get request is sent to
    //BUFFER= buffer to store data returned from the server
    //TIMEOUT_VAL= Time before the request times out
    HTTPResult r = httpClient.get("http://ip-api.com/csv",httpGetData,128); //GET GEOLOCATION DATA (CSV)

    if (r==HTTP_OK) { //IF THE DATA WAS RECIEVED
        j=0;
        //parse and display each of the API's location information strings on the LCD
        parse(httpGetData, &j, success); 
        parse(httpGetData,&j,countryFull);
        parse(httpGetData,&j,countryAbrv);
        parse(httpGetData,&j,stateAbrv);
        parse(httpGetData,&j,stateFull);
        parse(httpGetData,&j,city);
        parse(httpGetData,&j,zip);
        parse(httpGetData,&j,latitude);
        parse(httpGetData,&j,longitude);
        parse(httpGetData,&j,timeZone);
//        gOled.printf("HTTP Data Received\r\n");
//        gOled.display();
        printf("HTTP Data Received\r\n");
    } 
    else { //HTTP GET REQUEST ERRORED
//        gOled.printf("HTTP Error %d\r\n", r);
//        gOled.display();
        printf("HTTP Error %d\r\n", r);
        return -1;
    }
    printf("Reading Time...\r\n");
    char* domainName="kr.pool.ntp.org"; //SET TO DOMAIN NAME OF SERVER GETTING TIME FROM
    //GETS THE TIME FROM THE SERVER
    //setTime(DOMAIN_NAME,PORT_NUMBER,TIME_OUT)
    //DOMAIN_NAME= domain name
    //PORT NUMBER=port number (123 for NTP)
    //TIME_OUT= timeout value for request
    ntpClient.setTime(domainName,123,0x00005000);
    printf("Time Set\r\n");
    //Delay for human time to read LCD display
    wait(3.0);

    char buffer[80]; //BUFFER TO HOLD FORMATTED TIME DATA
//    gOled.printf("%s, %s %s, %s\r\n",city,stateAbrv,zip,countryAbrv); //PRINT CITY STATE AND ZIP INFORMATION AND COUNTRY
//    gOled.printf("LAT:%s\r\nLONG:%s\r\n",latitude,longitude); //PRINT LATITUDE AND LONGITUDE 
//    gOled.printf("Timezone:%s\r\n",timeZone); //PRINT TIMEZONE


    wizfi250.disconnect(); //DISCONNECT FROM THE NETWORK 
    while (1) {
        //ctTime = time(NULL)-(3600*4);  //TIME with offset for eastern time US
        ctTime = time(NULL)+(3600*9);  //TIME with offset for eastern time KR
        //FORMAT TIME FOR DISPLAY AND STORE FORMATTED RESULT IN BUFFER
        strftime(buffer,80,"%a %b %d\r\n%T %p %z\r\n %Z\r\n",localtime(&ctTime));
//        gOled.printf("Univ Time Clock\r\n%s\r\n", buffer);
//        gOled.display();
//        gOled.setTextCursor(0,40);
        printf("%s, %s %s, %s\r\n",city,stateAbrv,zip,countryAbrv); //PRINT CITY STATE AND ZIP INFORMATION AND COUNTRY
        printf("LAT:%s\r\nLONG:%s\r\n",latitude,longitude); //PRINT LATITUDE AND LONGITUDE 
        printf("Timezone:%s\r\n",timeZone); //PRINT TIMEZONE
        printf("Univ Time Clock\r\n%s\r\n", buffer);
        wait(1);
    }      
}

//SET FOR CSV FORMAT: NEEDS TO BE EDITED IF DIFFERENT FORMAT
void parse(char buffer[], int *j, char *string) {
//extracts next location string data item from buffer
    int i=0;
    for (i=0; i<=strlen(buffer); i++) {  //TOTAL SIZE OF RETURNED DATA
        if ((buffer[*j+i] == ',')||(buffer[*j+i] == '\0' )) { //IF comma or end of string
            //comma is the string field delimiter
            string[i]=0; //SETS END OF SRTRING TO 0
            *j=*j+i+1; //UPDATES to 1 after comma seperated value
            break;
        } else string[i]=buffer[*j+i]; //Keep adding to the string
    }
}
