#include "mbed.h"
#include "EthernetInterface.h"

#define MAC     "\x00\x08\xDC\x55\x51\x52"
#define IP      "192.168.0.20"
#define SUBNET  "255.255.255.0"
#define GATEWAY "192.168.0.1"

#define ECHO_SERVER_PORT    5000

//#define USE_DHCP

#define FLAG_LED_BLINK      3
#define FLAG_LED_ON         2
#define FLAG_LED_OFF        1
#define FLAG_INVALID_CMD    0

#define LED_ON              0
#define LED_OFF             1

void led_switch(void);

Ticker time_up;

/* LED Pin Configuration */
DigitalOut myled(LED1, LED_OFF);

/* UART Pin Configuration */
Serial pc(USBTX, USBRX);    

 // LED control if received message matches pre-defined commands
char cmd_ledon[] = {'L', 'E', 'D', '_', 'O', 'N', '\0'};
char cmd_ledoff[] = {'L', 'E', 'D', '_', 'O', 'F', 'F', '\0'};
char cmd_ledblink[] = {'L', 'E', 'D', '_', 'B', 'L', 'I', 'N', 'K', '\0'};

int flag; // LED status flag

void led_switch(void)
{
    if(flag == FLAG_LED_BLINK) {
        myled=!myled;       
    }
}

int main (void) 
{
    /* Serial baudrate configuration */
    pc.baud(115200);
    
    // mbed Ticker
    time_up.attach(&led_switch, 0.2);

    pc.printf("Wait a second...\r\n\r\n");
      
    // Ethernet  
    EthernetInterface eth;    
#ifdef USE_DHCP
    eth.init(MAC); // Use DHCP
#else
    eth.init((uint8_t*)MAC, IP, SUBNET, GATEWAY); // Use Static IP address
#endif    
    eth.connect();
    
    pc.printf("Server IP Address is %s : %d\r\n", eth.getIPAddress(), ECHO_SERVER_PORT);
    
    pc.printf("Command #1: %s\r\n", cmd_ledon);
    pc.printf("Command #2: %s\r\n", cmd_ledoff);
    pc.printf("Command #3: %s\r\n", cmd_ledblink);
    pc.printf("\r\n");
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) 
    {
        pc.printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        pc.printf("Connection from: %s\r\n", client.get_address());
        printf("\r\n");
        
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // Print received message to terminal
            buffer[n] = '\0';
            pc.printf("Received message from Client :'%s'\r\n",buffer);           
           
            // Compares the received string to predefined commands
            if(strncmp(buffer, cmd_ledon, sizeof(buffer)) == 0) {
                flag = FLAG_LED_ON;
            } else if(strncmp(buffer, cmd_ledoff, sizeof(buffer)) == 0) {
                flag = FLAG_LED_OFF;
            } else if(strncmp(buffer, cmd_ledblink, sizeof(buffer)) == 0) {
                flag = FLAG_LED_BLINK;
            } else {
                flag = FLAG_INVALID_CMD;    
            }
            
            // LED On/Off or Invalid command
            switch(flag)
            {
                case FLAG_LED_ON:
                    myled = LED_ON; // LED ON in WIZwiki-W7500
                    pc.printf("WIZwiki: LED is turned on!\r\n");
                    break;
                    
                case FLAG_LED_OFF:
                    myled = LED_OFF; // LED OFF in WIZwiki-W7500
                    pc.printf("WIZwiki: LED is turned off!\r\n");
                    break;
                
                case FLAG_LED_BLINK:                    
                    pc.printf("WIZwiki: LED starts blinking!\r\n");
                    break;
                    
                case FLAG_INVALID_CMD:
                default:                    
                    pc.printf("WIZwiki: Invalid command\r\n");
                    break;
            }
            
            // Reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
            }
            
            // Print reversed message to terminal
            pc.printf("Sending reversed message to Client: '%s'\r\n", buffer);
            pc.printf("\r\n");
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }    
}