#include "mbed.h"
#include "EthernetInterface.h"


#define API_key "" //Insert API key
Serial uart(USBTX, USBRX);

int main() {
   
    int phy_link;
    uart.baud(115200);
    uart.printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();

     do{
     phy_link = eth.ethernet_link();
     uart.printf("...");
     wait(2);
     }while(!phy_link);
     uart.printf("\r\n");
     
    uart.printf("IP Address is %s\r\n\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("api.openweathermap.org", 80);
    

    char http_cmd0[] = "GET /data/2.5/weather?q=Seoul,kr&appid=";
    char http_cmd1[] = API_key;
    char http_cmd2[] = " HTTP/1.0\n\n";
    
    sock.send_all(http_cmd0, sizeof(http_cmd0)-1);
    sock.send_all(http_cmd1, sizeof(http_cmd1)-1);
    sock.send_all(http_cmd2, sizeof(http_cmd2)-1);
    
    char buffer[400];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0) break;
        buffer[ret] = '\0';
        uart.printf("--Received %d chars from server:\r\n %s\r\n\n", ret, buffer);     
    }

    sock.close();
    
    eth.disconnect();

}