#include "mbed.h"
#include "EthernetInterface.h"

int main() {
   
    int phy_link;
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x1c, 0xa8, 0x95}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    
     do{
     phy_link = eth.ethernet_link();
     printf("...");
     wait(2);
     }while(!phy_link);
     printf("\r\n");
     
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("api.openweathermap.org", 80);
    

    char http_cmd[] = "GET /data/2.5/weather?q=Seoul,kr HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[400];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0) break;
        buffer[ret] = '\0';
        printf("Received %d chars from server: %s\n", ret, buffer);     
    }

    sock.close();
    
    eth.disconnect();

}