/**
 ******************************************************************************
 * @project  Smart BT Fan
 * @author  Justin Kim
 * @version V1.0.0
 * @date    29-JUN-2015
 * @brief   Main program body
*******************************************************************************
**/

/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "Servo.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
Serial bt(PA_14, PA_13);
Servo myservo(D14);
PwmOut Motor(D3);
DigitalOut direction(D12);
#endif

#if defined(TARGET_WIZwiki_W7500ECO)
Serial pc(USBTX, USBRX);
Serial bt(PA_13, PA_14); //echo
Servo myservo(P10); //echo
PwmOut Motor(P21); //echo
DigitalOut direction(P29); //echo
#endif



/* Private function prototypes -----------------------------------------------*/

/* Private functions ---------------------------------------------------------*/
/**
   * @brief     Main Function
   * @param  None
   * @retval    None
   */
int main(void)
{
    char ch;
    pc.baud(115200);
    //bt.baud(115200);
    bt.baud(9600);
    pc.printf("Hello World!\n\r");
    bt.printf("Hello World!\r\n");
    
    direction.write(1);
    Motor.period_ms(1);
    
    while(1)
    {
        if(bt.readable())
        {
            ch=bt.getc();
            pc.printf("%c",ch);
            bt.printf("%c",ch);
                                  
            if(ch == '*')
            {
                myservo = 0.5;
            }
            else if(ch == '+')
            {
                myservo = myservo + 0.1;
            }
            else if(ch == '-')
            {
                myservo = myservo - 0.1;
            }     
            else if(ch == '@')
            {
                Motor.write(0.8);
            }
            else if(ch == '!')
            {
                Motor.write(0);
            }
        }
        
        else if(pc.readable())
        {
            ch=pc.getc();
            bt.printf("%c",ch);
            pc.printf("%c",ch);            
                        
            if(ch == '*')
            {
                myservo = 0.5;
            }
            else if(ch == '+')
            {
                myservo = myservo + 0.1;
            }
            else if(ch == '-')
            {
                myservo = myservo - 0.1;
            }
            else if(ch == '@')
            {
                Motor.write(0.8);
            }
            else if(ch == '!')
            {
                Motor.write(0);
            }
        }
    }
}
