#include "mbed.h"

/* Digital Out Pin Configuration */
DigitalOut RED(D8,1);
DigitalOut GREEN(D9,1);
DigitalOut BLUE(D10,1);

/* UART Pin Configuration */
Serial pc(USBTX, USBRX);    
Serial bt(D1,D0);           


int main(void)
{   
    /* baudrate configuration */
    pc.baud(115200);
    bt.baud(9600);
    
    pc.printf("WIZwiki-W7500 BT\n\r");
    
    char ch;
    char msg[256];
    
    while(1)
    {
        /* WIZwiki-W7500 to Bluetooth */
        if(pc.readable())
        {
            pc.scanf("%s",&msg);
            bt.printf("%s",msg);
        }
        
        /* Bluetooth to WIZwiki-W7500 */
        if(bt.readable())
        {
            ch = bt.getc();
            pc.putc(ch);
            
            /* Control 3 colors LED */
            if(ch == 'r'){
                RED = !RED;
                /* Notice RED LED condition to Bluethooth */
                if(RED == 0)    bt.printf("RED ON");
                else            bt.printf("RED OFF");
            }else if(ch == 'g'){
                GREEN = !GREEN;
                /* Notice GREEN LED condition to Bluethooth */
                if(GREEN == 0)    bt.printf("GREEN ON");
                else              bt.printf("GREEN OFF");
            }else if(ch == 'b'){
                BLUE = !BLUE;
                /* Notice BLUE LED condition to Bluethooth */
                if(BLUE == 0)    bt.printf("BLUE ON");
                else             bt.printf("BLUE OFF");
            }
        }
        
    }
}
