
#include "mbed.h"

DigitalOut heater(A1);
AnalogIn sensor(A0);
DigitalOut led_r(LEDR);
DigitalOut led_g(LEDG);
DigitalOut led_b(LEDB);


int main(void)
{
    float value = 0.0f;
    
    led_g = 0;
    led_r = 0;
    led_b = 0;
    
    heater = 0;
    
    wait(0.1f);
    
    
    // Waiting for the sensor to warm-up
    while(value > 0.001f) {
        wait(1.0f);
        value = 1.0f - sensor;
        printf("Sensor is warming up : %2.2f\r\n", value);
    }
    led_g = 1;
    led_r = 1;
    led_b = 1;
    
    while(1)
    {
        value = 1- sensor;
        printf("%2.1f\r\n", value);
        if(value < 0.3)
        {
            led_g = 0;
            led_r = 1;
            led_b = 1;
        }
        else if(value < 0.7)
        {
            led_g = 1;
            led_r = 1;
            led_b = 0;
        }
        else
        {
            led_g = 1;
            led_r = 0;
            led_b = 1;
        }
        wait(1);
        
    }
}
