#include <stdio.h>
#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"

#define CITY        "Seoul"
#define COUNTRY     "kr"
#define API_KEY     "YOUR_API" //Fix This
#define WEB_SERVER  "api.openweathermap.org"

Serial pc(USBTX, USBRX);
EthernetInterface eth;
TCPSocketConnection sock;

uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xFF, 0xFF, 0xFF}; //Fix This

// Function Prototypes
void parsingGetData(void);
void initEthernet(uint8_t* mac_addr);
void requestHTTP(void);

int main() 
{
    pc.baud(115200);
    
    initEthernet(mac_addr);
    
    while(1)
    {
        requestHTTP();
        
        parsingGetData();
    
        sock.close();
        eth.disconnect();
        
        wait(60.0);
   };

}

/**
 * @brief   parsing Get Data from server
 * @detail  Function get data from server at once & parsing it for take needed data
 * @param   void
 * @return  void
 * @throws  return Occurs when the param value exceeds the specified range.
 */
void parsingGetData(void)
{
    char buffer[1024];
        
    /* get info */
    int ret;
    while (true) {
        ret = sock.receive_all(buffer, sizeof(buffer)-1);
        if (ret <= 0) break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    
    /* parsing weather, city, tempurature */
    char *weather;
    char *city;
    char *temp;
    uint8_t i;
    
    pc.printf("\r\n\r\n======== WeatherForecast ========\r\n");  
    weather = strstr(buffer, "main");
    pc.printf("\t State : ");
    for(i = 7; i < 20; i++)
    {
        if(*(weather+i) == '\"') break;
        pc.printf("%c", *(weather+i));
    }
            
    city = strstr(buffer, "name");
    pc.printf("\r\n\t City : ");
    for(i = 7; i < 20; i++)
    {
        if(*(city+i) == '\"') break;
        pc.printf("%c", *(city+i));
    }
        
    temp = strstr(buffer, "temp");
    pc.printf("\r\n\t temp(kelvin) : ");
    for(i = 6; i < 12; i++)
    {
        if((*(temp+i) == '\"')||(*(temp+i) == ',')) break;
        pc.printf("%c", *(temp+i));
    }
    pc.printf("\r\n\r\n");
}

/**
 * @brief   Request to server using HTTP.
 * @detail  Sends param values ​​to the server via HTTP.
 * @param   void
 * @return  void
 * @throws  
 */
void requestHTTP(void)
{
    char req_buf[256];
    
    /* TCP socket connect */   
    sock.connect(WEB_SERVER, 80);
    
    /* Request to WEB Server using HTTP */
    sprintf(req_buf,"GET /data/2.5/weather?q=%s,%s&appid=%s HTTP/1.1\nHost: %s\nConnection: close\n\n",
        CITY,COUNTRY, API_KEY, WEB_SERVER);
    sock.send_all(req_buf, strlen(req_buf));
}

/**
 * @brief   Initialize W5500 (Ethernet chip)
 * @detail  Function to initialize W5500 chip to use ethernet
 * @param   void
 * @return  void
 * @throws
 */
void initEthernet(uint8_t* mac_addr) {
    int phy_link;

    eth.init(mac_addr); //Use DHCP
    
    eth.connect();
        
    /* phy link */
    do{
       phy_link = eth.ethernet_link();
       printf(".");
       wait(2);
    }while(!phy_link);
    printf("\r\n");
         
    printf("IP Address is %s\r\n", eth.getIPAddress());
}