#include "mbed.h"
#include "GT511C3.hpp"
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

#define MAX_ID_NUM  20

#ifdef TARGET_WIZWIKI_W7500
GT511C3 finger(PA_13,PA_14);
DigitalIn del_ID(D7);
DigitalIn enroll_ID(D8);
InterruptIn in(D9);
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // the pinout on the mbed
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x11, 0x22, 0xab};
#endif

Serial pc(USBTX,USBRX);
EthernetInterface eth;
NTPClient ntpClient;

FILE *fp;


int progress(int status,char *msg)
{
    pc.printf("%s",msg);
    return 0;
}

void close_file(void)
{
    fclose(fp);
}

int main()
{
    int i;
    int sts = 0;
    int ID = 0;
    int cnt = 0;
    int EnrollID;
    
    char domainName[3][80] = {"kr.pool.ntp.org", "time.bora.net", "time.nuri.net"};//SET TO DOMAIN NAME OF SERVER GETTING TIME FROM
    char buffer[80]; //BUFFER TO HOLD FORMATTED TIME DATA
    time_t sysTime;
        
    in.rise(&close_file);

    pc.baud(115200);
    
    printf("File open...\r\n");
    
    if((fp = fopen("/sd/time.txt", "w")) == NULL)
    {
        printf("Cannot open file!!\r\n");
        return 0;
    }
    
    printf("GT511C3 open....\r\n");
    
    while(1)
    {
        sts = finger.Open();
        if(sts == -1)
        {
            printf("GT511C3 Open failed!!\r\n");
            cnt++;
            while(cnt > 5);
        }
        else
        {
            break;
        }
        
        wait(0.2);
    }
    
    if(del_ID == 1)
    {
        finger.DeleteID_All();
        printf("All ID are deleted!!\r\n");
    }
    
    cnt = 0;
    if(enroll_ID == 1)
    {
        while(1)
        {
            if(finger.CheckEnrolled(cnt) == -1)
            {
                EnrollID = cnt;
                printf("ID(%d) is empty\r\n", EnrollID);
                break;
            }
            cnt++;
            if(cnt > MAX_ID_NUM)
            {
                printf("\r\nERROR : ID number is fulled!!Delete ID first!!\r\n\r\n");
                while(1);
            }
        }
        finger.Enroll(EnrollID,progress);
    }
    
    eth.init(mac_addr); //Use DHCP
    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");
    printf("Getting IP address by DHCP...\r\n");
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    printf("Getting time information by using NTP...\r\n");
    
    cnt = 0;
    while(1)
    {
        if(ntpClient.setTime(domainName[cnt],123,0x00005000) != NTP_OK)
        {
            printf("Cannot get time information by NTP\r\n");
            cnt++;
        }
        else
            break;
            
        if(cnt > 3)
        {
            printf("All NTP servers are not resposed!!\r\n");
            return 1;
        }
    }
        
    printf("Completed Get and Set Time\r\n\r\n");
    eth.disconnect();
    
    //Start to capture fingerprint
    finger.CmosLed(1);
    
    while(1)
    {
        printf("Press finger for Identify\r\n");
        finger.WaitPress(1);
        if(finger.Capture(1) != 0)
            continue;
            
        ID = finger.Identify();
        
        if(ID == -1)
            printf("\r\nERROR : There is no ID!!Enroll first!!\r\n\r\n");
        else
        {
            printf("ID = %d\r\n",ID); 
            sysTime = time(NULL)+(3600*9); //TIME with offset for eastern time KR
            //FORMAT TIME FOR DISPLAY AND STORE FORMATTED RESULT IN BUFFER
            strftime(buffer,80,"%Y/%m/%d  %p %I:%M:%S \r\n",localtime(&sysTime));
            fprintf(fp, "ID : %d\r\nTime : %s\r\n", ID, buffer);
            printf("Date and Time\r\n%s\r\n", buffer);
        }
            
        printf("Remove finger\r\n");
        finger.WaitPress(0);
    }
}

