#include "mbed.h"
#include "GT511C3.h"

Serial debug(USBTX,USBRX);

DigitalOut myled(LED1);
GT511C3 finger(p28,p27);

int main() {
    unsigned long Parameter;
    unsigned short Response;
    int sts = 0;
    int count = 0;

    debug.format(8,Serial::None,1);
    debug.baud(115200);

    debug.printf("Init\n");
    finger.Init();
    debug.printf("Open\n");
    finger.SendCommand(0,GT511C3::CMD_Open);
    sts = finger.RecvResponse(&Parameter,&Response);
    debug.printf("sts = %d,Response=0x%04x\n",sts,Response);

    while(1) {
        debug.printf("Led\n");
        finger.SendCommand(count & 1,GT511C3::CMD_CmosLed);
        sts = finger.RecvResponse(&Parameter,&Response);
        debug.printf("sts = %d,Response=0x%04x\n",sts,Response);
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
        count++;
    }
}
