
#include "mbed.h"
#include "GT511C3.h"

#define SET_AND_SUMADD(idx,val) sendbuf[idx]=((unsigned char)(val));sum += sendbuf[idx]

int GT511C3::Init(void)
{
    baud(9600);
    ClearLine();
    return 0;
}

int GT511C3::SendCommand(unsigned long Parameter,unsigned short Command)
{
    unsigned char sendbuf[12];
    unsigned short sum = 0;
    int idx = 0;
    int i;

    SET_AND_SUMADD(idx,0x55); idx++;
    SET_AND_SUMADD(idx,0xAA); idx++;
    SET_AND_SUMADD(idx,0x01); idx++;
    SET_AND_SUMADD(idx,0x00); idx++;
    SET_AND_SUMADD(idx,Parameter & 0xff); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 8) & 0xff); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 16) & 0xff); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 24) & 0xff); idx++;
    SET_AND_SUMADD(idx,Command & 0xff); idx++;
    SET_AND_SUMADD(idx,(Command >> 8) & 0xff); idx++;
    sendbuf[idx] = sum & 0xff; idx++;
    sendbuf[idx] = (sum >> 8) & 0xff; idx++;

    for(i = 0;i < idx;i++){
        while(!writeable());
        putc(sendbuf[i]);
    }
    return idx;
}

int GT511C3::RecvResponse(unsigned long *Parameter,unsigned short *Response)
{
    unsigned char buf[12];
    unsigned short sum = 0;
    int i;

    *Parameter = 0;
    *Response = CMD_Nack;

    for(i = 0;i < sizeof(buf);i++){
        while(!readable());
        buf[i] = getc();
        if(i < 9){
            sum += buf[i];
        }
        if((i == 0) && (buf[i] != 0x55))
            return -1;
        if((i == 1) && (buf[i] != 0xAA))
            return -1;
    }
    if(buf[10] != (sum & 0xff))
        return -2;
    if(buf[11] != ((sum >> 8) & 0xff))
        return -2;

    *Parameter =  buf[7];
    *Parameter = (*Parameter << 8) | buf[6];
    *Parameter = (*Parameter << 8) | buf[5];
    *Parameter = (*Parameter << 8) | buf[4];

    *Response = buf[9];
    *Response = (*Response << 8) | buf[8];

    return 0;
}

int GT511C3::ClearLine(void)
{
    while(readable()){
        (void)getc();
    }
    return 0;
}

