#include "mbed.h"
#include "GT511C3.hpp"

#define MAX_ID_NUM  20

Serial debug(USBTX,USBRX);


#ifdef TARGET_WIZWIKI_W7500
GT511C3 finger(PA_13,PA_14);
DigitalIn del_ID(D7);
DigitalIn enroll_ID(D8);
#endif

int progress(int status,char *msg)
{
    debug.printf("%s",msg);
    return 0;
}

int main()
{
    int sts = 0;
    int ID = 0;
    int cnt = 0;
    int EnrollID;

    debug.baud(115200);
    printf("Try to Open Device....\r\n");
    
    while(1)
    {
        sts = finger.Open();
        if(sts == -1)
        {
            printf("Open failed!!\r\n");
            cnt++;
            while(cnt > 5);
        }
        else
        {
            printf("Open Success!!\r\n");
            break;
        }
        wait(0.2);
    }
    
    if(del_ID == 1)
    {
        finger.DeleteID_All();
        printf("All ID are deleted!!\r\n");
    }
    
    cnt = 0;
    if(enroll_ID == 1)
    {
        while(1)
        {
            if(finger.CheckEnrolled(cnt) == -1)
            {
                EnrollID = cnt;
                printf("ID(%d) is empty\r\n", EnrollID);
                break;
            }
            cnt++;
            if(cnt > MAX_ID_NUM)
            {
                printf("\r\nERROR : ID number is fulled!!Delete ID first!!\r\n\r\n");
                while(1);
            }
        }
        finger.Enroll(EnrollID,progress);
    }
    
    finger.CmosLed(1);
    
    while(1)
    {
        printf("Press finger for Identify\r\n");
        finger.WaitPress(1);
        if(finger.Capture(1) != 0)
            continue;
            
        ID = finger.Identify();
        
        if(ID == -1)
            printf("\r\nERROR : There is no ID!!Enroll first!!\r\n\r\n");
        else
            printf("ID = %d\r\n",ID); 
            
        printf("Remove finger\r\n");
        finger.WaitPress(0);
        
    }
    
        
}

