#include "mbed.h"
#include "EthernetInterface.h"

//#define UDPServer 1
#define UDPClient 1

#if defined (UDPServer)
#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.99.100"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.99.1"

#else // UDPClient
#define MAC     "\x00\x08\xDC\x11\x34\x90"
#define IP      "192.168.99.101"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.99.1"
#endif

#define MAX_BUF_SIZE 128

AnalogIn mic(A5);
PwmOut trigger_o (D14);
InterruptIn trigger_i (D15);
DigitalIn button (A0);
DigitalOut toggle (D0);
DigitalOut sent (D1);
PwmOut aout (D12);

Serial pc (USBTX, USBRX);

char ad_data_buf0[MAX_BUF_SIZE];
char ad_data_buf1[MAX_BUF_SIZE];
int i = 0;
char buf_sel = 0;
char send_udp = 0;

int n; 

const char* ECHO_SERVER_ADDRESS = "192.168.99.100";
const int ECHO_SERVER_PORT = 3000;
const int ECHO_CLIENT_PORT = 2000;

void adcTickfunc() {
# if defined (UDPServer)
    if (buf_sel) aout.write((float)ad_data_buf1[i]/256*1.32);
    else         aout.write((float)ad_data_buf0[i]/256*1.32);
    i++;
    
    if (i == MAX_BUF_SIZE) i = MAX_BUF_SIZE - 1;
# else
    if (buf_sel == 0) ad_data_buf0[i] = mic.read_u16() >> 4;
    else              ad_data_buf1[i] = mic.read_u16() >> 4;
    i++;
    
    if (i == MAX_BUF_SIZE) { 
        i = 0;
        toggle = !toggle;
        if (buf_sel) buf_sel = 0; else buf_sel = 1;
        send_udp = 1;
        sent = 1;
    }
#endif
}    

int main (void) {
    // baud setting
    pc.baud(460800);    
    trigger_i.rise (&adcTickfunc);
    
    EthernetInterface eth;
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    printf("\r\nConnecting");
    eth.connect();
#if defined UDPServer
    while (true) {  
        UDPSocket server;
        server.bind(ECHO_SERVER_PORT);
        Endpoint client;
        
        // Start acquisition (interval 100usec)
        trigger_o.period_us(100);
        trigger_o.write(0.50f);
        
        aout.period_us(50);
             
        while (true) {
            if (buf_sel) n = server.receiveFrom(client, ad_data_buf0, sizeof(ad_data_buf0));
            else         n = server.receiveFrom(client, ad_data_buf1, sizeof(ad_data_buf1));  
            printf ("\r\n%d",i);
            toggle = buf_sel;
            //receive_udp = receive_udp + 1;
            if (buf_sel) buf_sel = 0; else buf_sel = 1;
            i = 0;
            if (n <= 0) break;
        }
    }
#else
    printf("\r\nClient IP Address is %s", eth.getIPAddress());
    UDPSocket sock;
    sock.init();
    sock.bind(ECHO_CLIENT_PORT);
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    printf("\r\nip= %s,port=%d",echo_server.get_address(),echo_server.get_port());
    
    // Start acquisition (interval 100usec)
    trigger_o.period_us(100);
    trigger_o.write(0.50f);
    
    while (1) {
        if (send_udp) {
            if (buf_sel == 1) sock.sendTo(echo_server, ad_data_buf0, MAX_BUF_SIZE);
            else              sock.sendTo(echo_server, ad_data_buf1, MAX_BUF_SIZE);
            send_udp = 0;
            sent = 0;
        }
    }
#endif
}
