#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"


RawSerial pc(USBTX, USBRX); // tx, rx 

DigitalOut led1(LED1);
DigitalOut led2(LED2);

const char* TEST_SERVER_ADDRESS = "192.168.3.64";
const int TEST_SERVER_PORT = 8000;

ESP8266Interface wifi(D1, D0, D2, "WizFiDemoAP","12345678",115200); // tx, rx 


// For monitoring data from ESP8266
Timeout timer_buffer_debug;
CircBuffer<char> buffer_ESP8266_recv(1024);

void print_buffer_ESP8266()
{
    char c=0;
    while ( buffer_ESP8266_recv.available() ) {
        buffer_ESP8266_recv.dequeue(&c);
        pc.putc(c);
    }
    timer_buffer_debug.attach(&print_buffer_ESP8266, 0.1);
}


int main()
{
    // LED Blink
    for (int i=0; i<5; i++) {
        led1 = 1;
        wait(0.1);        
        led1 = 0;
        wait(0.1);
    }

    pc.baud(115200);
    pc.printf("\r\nWIZwiki-W7500 with ESP8266 Test. \r\n");
    
    timer_buffer_debug.attach(&print_buffer_ESP8266, 0.5);
    
    bool result;
    wifi.init();
    result = wifi.connect();
    if ( !result )  {
        pc.printf("wifi.connect error\r\n");
        return 0;
    }

    TCPSocketConnection socket;
    while (socket.connect(TEST_SERVER_ADDRESS, TEST_SERVER_PORT) < 0) {
        pc.printf("Unable to connect to (%s) on port (%d)\n", TEST_SERVER_ADDRESS, TEST_SERVER_PORT);
        wait(1);
    }

    char hello[] = "Hello World\r\n";
    socket.send_all(hello, sizeof(hello) - 1);
    socket.close();

    while(true) {}
}
