#include "mbed.h"

#include "ESP8266Interface.h"
#include "EthernetInterface.hpp"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

ESP8266Interface wifi(D1, D0, D2, "WizFiDemoAP","12345678",115200); // tx, rx for
wiznet_space::EthernetInterface eth;

RawSerial pc(USBTX, USBRX); // tx, rx

extern void ProcessDataViaEthernet();
extern void ProcessDataViaWiFi();

// For monitoring data from ESP8266
Timeout timer_buffer_debug;
CircBuffer<char> buffer_ESP8266_recv(1024);

void print_buffer_ESP8266()
{
    char c=0;
    while ( buffer_ESP8266_recv.available() ) {
        buffer_ESP8266_recv.dequeue(&c);
        pc.putc(c);
    }
    timer_buffer_debug.attach(&print_buffer_ESP8266, 0.1);
}


bool InitializeWiznetEthernet()
{
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xFF, 0x11, 0x22};
 
    //eth.init(mac_addr); //Use DHCP
    eth.init(mac_addr, "192.168.3.102", "255.255.255.0", "192.168.3.1"); //Use DHCP
    
    // Check Ethenret Link
    if( eth.link()!=true )
    {
        printf("- Ethernet PHY Link- Fail\r\n");
        return false;
    }
     
    // Start Ethernet connecting: Trying to get an IP address using DHCP
    if ( eth.connect() < 0 ){
        printf("Fail - Ethernet Connecing");
        return false;
    }

    //pc.printf("IP Address(Ethernet Interface) is %s\r\n", eth.getIPAddress());

    return true;
}

bool InitializeESP8266()
{   
    // if you don't want to monitor ESP-module-data, remove below line.
    //timer_buffer_debug.attach(&print_buffer_ESP8266, 0.5);    
  
    wifi.init();

    bool result = wifi.connect();
    if ( !result )  {
        pc.printf("wifi.connect error\r\n");
        return false;
    }

    //pc.printf("IP Address(WiFi Interface) is %s\r\n", wifi.getIPAddress());
    return true;
}


int main()
{
    // Initialize LED
    for (int i=0; i<20; i++)
    {        
        led1 = !led1;
        led2 = !led2;
        wait(0.05);
    }

    // Initialize UART
    pc.baud(115200);
    pc.printf("\r\nDual Network Interface Test.\r\n");

    // Ethernet : WIZnet hardwired TCP/IP in W7500
    if ( InitializeWiznetEthernet() )
    {
        ProcessDataViaEthernet();
        pc.printf("WIZnet hardwired TCP/IP in W7500 Test Done.\r\n");
    }    
    
    // WiFi : ESP8266
    if ( InitializeESP8266() )
    {
        ProcessDataViaWiFi();
        pc.printf("ESP8266 Test Done.\r\n");
    }
    
    
    while(1) {
        wait(1);
    }
}

