#include "mbed.h"
#include "DHT.h"

#define   DHT_DATA_PIN  D4
 
DHT sensor(DHT_DATA_PIN, DHT11);                    //DHT(PinName pin, eType DHTtype)
 
int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
 
    while(1) 
    {
        wait(2.0f);                                 //wait 2 second
        error = sensor.readData();                  //read error value
        if (error == 0)                             //case: no error 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            printf("Temperature in Kelvin: %4.2f, Celcius: %4.2f, Farenheit %4.2f\n", k, c, f);
            printf("Humidity is %4.2f, Dewpoint: %4.2f, Dewpoint fast: %4.2f\n", h, dp, dpf);
        } 
        else                                        //case: error
        {
            printf("Error: %d\n", error);
        }
    }
}