#include "mbed.h"
#include "EthernetInterface.h"
#include "DDNSClient.h"
#define DEBUG
DDNSClient::DDNSClient() 
{
    noip_ddns = "dynupdate.no-ip.com";
    noip_ddns_port = 80;    
    
    check_ip = "checkip.dyndns.com";
    check_ip_port = 80; 
}
DDNSClient::~DDNSClient()
{
  
}
void DDNSClient::updateNoIP(void)
{
    char buf[1024]={0,};

#ifdef DEBUG
    printf("Updating NoIP...\r\n");       
#endif
    while (DDNSupdate.connect(noip_ddns, noip_ddns_port) < 0) {
    #ifdef DEBUG
        printf("Unable to connect to (%s) on port (%d)\r\n", noip_ddns, noip_ddns_port);
    #endif
        wait(0.5);
    } 
#ifdef DEBUG
    printf("Sended message to server :\r\n");
#endif  
    snprintf(buf, sizeof(buf), "GET /nic/update?hostname=%s&myip=%s HTTP/1.0\r\n", _hostname, _ip);                                                               
    DDNSupdate.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif
    
    snprintf(buf, sizeof(buf), "Host: dynupdate.no-ip.com\r\n"); //Write request                                                                 
    DDNSupdate.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif
    
    snprintf(buf, sizeof(buf), "Authorization: Basic %s\r\n", _idpass); //Write request                                                                 
    DDNSupdate.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif
    
    snprintf(buf, sizeof(buf), "User-Agent: mbed client/1.0 ricky@wiznet.co.kr\r\n\r\n"); //Write request                                                                 
    DDNSupdate.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif

#ifdef DEBUG
    printf("Received message from server :\r\n");
#endif

    wait(5.0);
    memset(buf, 0, sizeof(buf));
    DDNSupdate.receive_all(buf, sizeof(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif

    wait(5.0);
    memset(buf, 0, sizeof(buf));
    DDNSupdate.receive_all(buf, sizeof(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif

    DDNSupdate.close();
    
}
void DDNSClient::userSetNoIP(char* idpass, char* hostname)
{
    _hostname = hostname;
    _idpass = idpass;
}
void DDNSClient::checkIp(void)
{
    char buf[1024]={0,};
    char* tok;
    
#ifdef DEBUG
    printf("Checiking IP...\r\n");       
#endif
    while (CheckIp.connect(check_ip, check_ip_port) < 0) {
    #ifdef DEBUG
        printf("Unable to connect to (%s) on port (%d)\r\n", check_ip, check_ip_port);
    #endif
        wait(0.5);
    } 
#ifdef DEBUG
    printf("Sended message to server :\r\n");
#endif  
    snprintf(buf, sizeof(buf), "GET / HTTP/1.0\r\n", _hostname, _ip);                                                               
    CheckIp.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif
    snprintf(buf, sizeof(buf), "Host: checkip.dyndns.com\r\n\r\n");                                                               
    CheckIp.send(buf, strlen(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif

#ifdef DEBUG
    printf("Received message from server :\r\n");
#endif

    wait(3.0);
    memset(buf, 0, sizeof(buf));
    CheckIp.receive_all(buf, sizeof(buf));
#ifdef DEBUG
    printf("%s", buf);
#endif

    tok = strstr(buf, "Address: ");
    tok = strtok(tok+9, "<");
    _ip = tok;
    
#ifdef DEBUG
    printf("IP:%s", tok);
#endif
    CheckIp.close();
}