/**
 * Test program.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

/*
 * Include files.
 */

#include "mbed.h"
#include "CameraC328.h"
#include "SDFileSystem.h"

/*
 * Definitions.
 */
#define USE_JPEG_HIGH_RESOLUTION  1
#define USE_SD_CARD 1

/*
 * Variables.
 */
static const int CAPTURE_FRAMES = 1;
static FILE *fp_jpeg;

/*
 * Modules.
 */
#if USE_SD_CARD
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "fs"); // the pinout on the mbed Cool Components workshop board
#else
LocalFileSystem fs("fs");
#endif
CameraC328 camera(PA_13, PA_14, CameraC328::Baud115200);

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}

/**
 * Synchronizing.
 */
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\n", (int)err);
    }
}

/**
 * A test function for jpeg snapshot picture.
 */
void test_jpeg_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

#if USE_JPEG_HIGH_RESOLUTION
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
#else
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution320x240);
#endif
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\n", (int)err);
    }

    for (int i = 0; i < CAPTURE_FRAMES; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jpss%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");

        err = camera.getJpegSnapshotPicture(jpeg_callback);
        if (CameraC328::NoError == err) {
            printf("[ OK ] : CameraC328::getJpegSnapshotPicture\n");
        } else {
            printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\n", (int)err);
        }

        fclose(fp_jpeg);
    }
}

/**
 * A entry point.
 */
int main() {
    printf("\n");
    printf("==========\n");
    printf("CameraC328\n");
    printf("==========\n");

    sync();

    test_jpeg_snapshot_picture();
}
