#include "mbed.h"
#include "EthernetInterface.h"
 
AnalogIn pot1(A0);
AnalogIn pot2(A1);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

#ifdef TARGET_WIZwiki_W7500
EthernetInterface eth;
#else

#if defined(TARGET_NUCLEO_F103RB)
SPI spi(PA_7, PA_6, PA_5);               // mosi, miso, sclk
EthernetInterface eth(&spi, PB_6, PA_9); // spi, cs, reset
#else //tested on FRDM-KL25Z, LPCXpresso8324-MAX
SPI spi(D11, D12, D13);                  // mosi, miso, sclk
EthernetInterface eth(&spi, D10, D9);    // spi, cs, reset
#endif    

#endif //#if defined TARGET_WIZwiki_W7500

TCPSocketConnection sock;

int main() 
{
    //uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x1D, 0xFE, 0x1B}; 
    char *MODEL = "mbed";
    char *SERIAL_NUM = "input_your_serial_num"; 
    float DEADBAND = 0.015;   
    char* ip;
    
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;

    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;

    printf("initializing Ethernet\r\n");
    eth.init(mac_addr); //Use DHCP    
    if ( returnCode == 0 )
    {
        printf(" - Ethernet ready\r\n");
        led1 = returnCode;
    }
    else
    {
        printf(" - Could not initialize Ethernet - ending\r\n");
        return 0;
    }

    eth.ethernet_link();
    printf("eth.ethernet_link() %d \r\n", eth.ethernet_link());
    
    printf("Ethernet.connecting \r\n");
    returnCode = eth.connect();

    printf(" - connecting returned %d \r\n", returnCode);
    led2 = returnCode != -1 ? 0: 1;
    printf("Trying to get IP address..\r\n");
    ip = eth.getIPAddress();
    led3 = strlen(ip)<4 ? 1: 0;
    printf("  -  IP address:%s\r\n", ip);
    
    float oil_level = 0.0;
    float oil_level2= 0.0;
    float oldPotVal = -2.0;
    float oldPotVal2 = -2.0;
    
    while(1) {
        oil_level = pot1.read();
        oil_level2= pot2.read();
        
        if ( abs(oil_level - oldPotVal) < DEADBAND && abs(oil_level2 - oldPotVal2) < DEADBAND)
        {
            continue;   
        }
        else
        {
            led4 = 1;
            oldPotVal = oil_level;
            oldPotVal2 = oil_level2;
            printf("Sending Value for well1 %.2f\n\r", oil_level);
            printf("Sending Value for well2 %.2f\n\r", oil_level2);
            sock.connect("toolbox-connect.axeda.com", 80);
 
            snprintf(http_cmd, http_cmd_sz,  "POST /ammp/data/1/%s!%s HTTP/1.1\r\nContent-Type: application/json\r\nContent-Length: 65\r\n\r\n{\"data\":[{\"di\":{\"oil_level\":%.2f, \"oil_level2\":%.2f}}]}\r\n\r\n", MODEL, SERIAL_NUM, oil_level, oil_level2);
            sock.send_all(http_cmd, http_cmd_sz-1);
    
            while ( (returnCode = sock.receive(buffer, buffer_sz-1)) > 0)
            {
                buffer[returnCode] = '\0';
                printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
            }
            led4 = returnCode;
            sock.close();
        }
 
    }
 
}
