#include <stdio.h>
#include "mbed.h"
#include "WizFi250Interface.h"

#define SECURE WizFi250::SEC_AUTO
#define SSID "ssid"
#define PASS "key"


#if defined(TARGET_WIZwiki_W7500)
    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    Serial pc(USBTX,USBRX);
#endif

AnalogIn pot1(A0);
TCPSocketConnection sock;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
 
int main() 
{
    char *MODEL = "mbed";
    char *SERIAL_NUM = "serial number"; 
    float DEADBAND = 0.03;
    
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz];
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;
    
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    
    pc.baud(115200);

    wizfi250.init();
    returnCode = wizfi250.connect(SECURE, SSID, PASS);

    if ( returnCode == 0 )
    {
        printf(" - WiFi Ready\r\n");
        printf("IP Address is %s\r\n", wizfi250.getIPAddress());
        led1 = returnCode;
    }
    else
    {
        printf(" - Could not initialize WiFi - ending\r\n");
        return 0;
    }
    
    float oil_level = 0.0;
    float oldPotVal = -2.0;
    
    while(1) {
        oil_level = pot1.read();
        
        if ( abs(oil_level - oldPotVal) < DEADBAND)
        {
            continue;   
        }
        else
        {
            oldPotVal = oil_level;
            printf("Sending Value for well1 %.2f\n\r", oil_level);
            sock.connect("toolbox-connect.axeda.com", 80);
 
            snprintf(http_cmd, http_cmd_sz,  "POST /ammp/data/1/%s!%s HTTP/1.1\r\nContent-Type: application/json\r\nContent-Length: 65\r\n\r\n{\"data\":[{\"di\":{\"oil_level\":%.2f}}]}\r\n\r\n", MODEL, SERIAL_NUM, oil_level);
            sock.send_all(http_cmd, http_cmd_sz-1);

            while ( (returnCode = sock.receive(buffer, buffer_sz-1)) > 0)
            {
                buffer[returnCode] = '\0';
                printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
            }

            sock.close();
        }
     }
}