#include "mbed.h"
#include "rtos.h"
#include "Servo.h"
#include "C12832.h"
Servo motor(p21);
Servo s2(p22);
Serial pc(USBTX, USBRX);
Mutex mutexIn;
Mutex mutexOut;

AnalogIn p1(p19);
AnalogIn p2(p20);

// Globel variables
char cordinates[20];
char corHoriz[20];
char corVertic[20];
//float corDeep;
float outVert;
//float outHoriz;
C12832 lcd(p5, p7, p6, p8, p11);// lcd is an object from class c12832 initialised by p5,p7....

/* Thread Serial 1 - handles the output data from the control thread, and pass to the servo.
    @update s1, s2 */
void serial_thread(void const *args) {
    while (true) {
        mutexIn.lock();
      //  pc.gets(cordinates,4);
     //   cordinates = pc.putc(pc.getc());
         pc.scanf("%s \n %s \n ",corHoriz,corVertic);// read from serial port the data
         // look for carriage return and assign the first number of to the cordinates and then the second to corHiz 
         
         //corHoriz=cordinates;
        // corHoriz=(cordinates[0]+cordinates[1]+cordinates[2]+cordinates[3]);
        // corVertic=(cordinates[4]+cordinates[5]+cordinates[6]+cordinates[7]);
        Thread::wait(200);
        //corVertic = cordinates[1];
//        corDeep = cordinates[2];
        mutexIn.unlock();
        
    }
}
 
/* Thread LCD 2 - handles the input data from the sonar sensor, and display on the LCD screen.
    @update inData */
void lcd_thread(void const *args) {
    while (true) {
        mutexIn.lock();
        mutexOut.lock();
        // Display values on the LCD screen
        lcd.cls();          // clear the display
        lcd.locate(0,5);    // the location where you want your charater to be displayed
        lcd.printf("hors%s", corHoriz);
        lcd.locate(0,20);    // the location where you want your charater to be displayed
        lcd.printf("Ver%s", corVertic);
        mutexIn.unlock();
        mutexOut.unlock();
        Thread::wait(25);
    }
}

/* Thread Control 3 - handles the input data from the sonar sensor, and display on the LCD screen.
    @update inData */
void control_thread(void const *args) {
    while (true) {
        mutexIn.lock();
        // The control code will come here
        if (corHoriz[1]=='1')
        motor =motor+0.25;
        else
        motor=motor-0.25;
        
        mutexIn.unlock();
        Thread::wait(25);
    }
}

/* Thread Servo 4 - handles the output data from the control thread, and pass to the servo.
    @update s1, s2 */
void servo_thread(void const *args) {
    while (true) {
        mutexOut.lock();
//        s1 = outVert;
//        s2 = outHoriz;
        mutexOut.unlock();
        Thread::wait(200);
    }
}

int main() {
    Thread thread_1(serial_thread); // Start Serial Thread
    Thread thread_2(lcd_thread); // Start LCD Thread
    Thread thread_3(control_thread); // Start Control Thread
    Thread thread_4(servo_thread); // Start Servo Thread
    while(1) {
        Thread::wait(10);
    }
}
