#include "mbed.h"
#include "rtos.h"
#include "Servo.h"
#include "C12832.h"

Servo s1(p21); 
Servo s2(p22);
AnalogIn p1(p17); // Sonar sensor 1
//AnalogIn p2(p20); // Sonar sensor 2 (not used yet)
Mutex dataIn_mutex; 
Mutex dataOut_mutex;

// Global variables
float input_data;
float output_data;
C12832 lcd(p5, p7, p6, p8, p11); // lcd is an object from class C12832 initialised by p5,p7....

/* Thread Sonar - handles the input data from the sonar sensor, and display on the LCD screen.
    @update input_data 
    */
void sonar_thread(void const *args)
{
    while (true) {
        dataIn_mutex.lock();
        // Read the sensor and assign to input_data global variable
        input_data= p1.read()*5;
        // Display the input_data
        lcd.cls();      // clear the display
        lcd.locate(0,3);// the location where you want your charater to be displayed
        lcd.printf("Thread one = %f\n", input_data);
        // Handles the thread
        dataIn_mutex.unlock();
        Thread::wait(25);
    }
}

/* Thread Control -  */
void control_thread(void const *args)
{
    while (true) {
        dataIn_mutex.lock();
        // Modification on the input_data and assign to servo2
        if (input_data>0.8) {
            s2=input_data*0.2;
        } else if(input_data<0.8) {
            s2=-input_data*0.5;
        }
        // Assign input_data to servo1 without modification
        s1=input_data; 
        // Handles the thread
        dataIn_mutex.unlock();
        Thread::wait(20);
    }
}

/* Main method - Start threads and delay them by waiting. */
int main()
{
    Thread thread(sonar_thread); // Start Sonar Thread
    Thread thread_1(control_thread); // Start Control Thread
    // Delay the threads
    while (true) {
        Thread::wait(10); 
    }
}