// date 7/6/2015
// author E wendt

//TSL2561 light sensor library

#ifndef _TSL2561_H_
#define _TSL2561_H_

#include "mbed.h"
//#define TSL2561_ADDRESS (0x72)

#define TSL2561_VISIBLE 2                   // channel 0 - channel 1
#define TSL2561_INFRARED 1                  // channel 1
#define TSL2561_FULLSPECTRUM 0              // channel 0

// 3 i2c address options!
//#define TSL2561_ADDR_LOW  0x52
#define TSL2561_ADDR_FLOAT (0x72)
//#define TSL2561_ADDR_HIGH 0x92

// Lux calculations differ slightly for CS package
//#define TSL2561_PACKAGE_CS
#define TSL2561_PACKAGE_T_FN_CL

#define TSL2561_READBIT           (0x01)

#define TSL2561_COMMAND_BIT       (0x80)    // Must be 1
#define TSL2561_CLEAR_BIT         (0x40)    // Clears any pending interrupt (write 1 to clear)
#define TSL2561_WORD_BIT          (0x20)    // 1 = read/write word (rather than byte)
#define TSL2561_BLOCK_BIT         (0x10)    // 1 = using block read/write

#define TSL2561_CONTROL_POWERON   (0x03)
#define TSL2561_CONTROL_POWEROFF  (0x00)

//ID
#define I_AM_TSL2561                0x50
#define REG_NO_MASK                 0x0F

//different timing and gain settings
/*#define TSL2561_INTEGRATIONTIME_13MS      (0x00)    // 13.7ms
#define TSL2561_INTEGRATIONTIME_101MS     (0x01)    // 101ms
#define TSL2561_INTEGRATIONTIME_402MS     (0x02)    // 402ms

#define TSL2561_GAIN_0X           (0x00)  //x1
#define TSL2561_GAIN_16X          (0x10)  //x16*/


#define LUX_SCALE 14 // scale by 2^14
#define RATIO_SCALE 9 // scale ratio by 2^9

//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−
// Integration time scaling factors
//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−

#define CH_SCALE 10 // scale channel values by 2^10
#define CHSCALE_TINT0 0x7517 // 322/11 * 2^CH_SCALE
#define CHSCALE_TINT1 0x0fe7 // 322/81 * 2^CH_SCALE

//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−
// T, FN, and CL Package coefficients
//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−
// For Ch1/Ch0=0.00 to 0.50
// Lux/Ch0=0.0304−0.062*((Ch1/Ch0)^1.4)
// piecewise approximation
// For Ch1/Ch0=0.00 to 0.125:
// Lux/Ch0=0.0304−0.0272*(Ch1/Ch0)
//
// For Ch1/Ch0=0.125 to 0.250:
// Lux/Ch0=0.0325−0.0440*(Ch1/Ch0)
//
// For Ch1/Ch0=0.250 to 0.375:
// Lux/Ch0=0.0351−0.0544*(Ch1/Ch0)
//
// For Ch1/Ch0=0.375 to 0.50:
// Lux/Ch0=0.0381−0.0624*(Ch1/Ch0)
//
// For Ch1/Ch0=0.50 to 0.61:
// Lux/Ch0=0.0224−0.031*(Ch1/Ch0)
//
// For Ch1/Ch0=0.61 to 0.80:
// Lux/Ch0=0.0128−0.0153*(Ch1/Ch0)
//
// For Ch1/Ch0=0.80 to 1.30:
// Lux/Ch0=0.00146−0.00112*(Ch1/Ch0)
//
// For Ch1/Ch0>1.3:
// Lux/Ch0=0
//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−

#define K1T 0x0040 // 0.125 * 2^RATIO_SCALE
#define B1T 0x01f2 // 0.0304 * 2^LUX_SCALE
#define M1T 0x01be // 0.0272 * 2^LUX_SCALE

#define K2T 0x0080 // 0.250 * 2^RATIO_SCALE
#define B2T 0x0214 // 0.0325 * 2^LUX_SCALE
#define M2T 0x02d1 // 0.0440 * 2^LUX_SCALE

#define K3T 0x00c0 // 0.375 * 2^RATIO_SCALE
#define B3T 0x023f // 0.0351 * 2^LUX_SCALE
#define M3T 0x037b // 0.0544 * 2^LUX_SCALE

#define K4T 0x0100 // 0.50 * 2^RATIO_SCALE
#define B4T 0x0270 // 0.0381 * 2^LUX_SCALE
#define M4T 0x03fe // 0.0624 * 2^LUX_SCALE

#define K5T 0x0138 // 0.61 * 2^RATIO_SCALE
#define B5T 0x016f // 0.0224 * 2^LUX_SCALE
#define M5T 0x01fc // 0.0310 * 2^LUX_SCALE

#define K6T 0x019a // 0.80 * 2^RATIO_SCALE
#define B6T 0x00d2 // 0.0128 * 2^LUX_SCALE
#define M6T 0x00fb // 0.0153 * 2^LUX_SCALE

#define K7T 0x029a // 1.3 * 2^RATIO_SCALE
#define B7T 0x0018 // 0.00146 * 2^LUX_SCALE
#define M7T 0x0012 // 0.00112 * 2^LUX_SCALE

#define K8T 0x029a // 1.3 * 2^RATIO_SCALE
#define B8T 0x0000 // 0.000 * 2^LUX_SCALE
#define M8T 0x0000 // 0.000 * 2^LUX_SCALE

//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−
// CS package coefficients
//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−
// For 0 <= Ch1/Ch0 <= 0.52
// Lux/Ch0 = 0.0315−0.0593*((Ch1/Ch0)^1.4)
// piecewise approximation
// For 0 <= Ch1/Ch0 <= 0.13
// Lux/Ch0 = 0.0315−0.0262*(Ch1/Ch0)
// For 0.13 <= Ch1/Ch0 <= 0.26
// Lux/Ch0 = 0.0337−0.0430*(Ch1/Ch0)
// For 0.26 <= Ch1/Ch0 <= 0.39
// Lux/Ch0 = 0.0363−0.0529*(Ch1/Ch0)
// For 0.39 <= Ch1/Ch0 <= 0.52
// Lux/Ch0 = 0.0392−0.0605*(Ch1/Ch0)
// For 0.52 < Ch1/Ch0 <= 0.65
// Lux/Ch0 = 0.0229−0.0291*(Ch1/Ch0)
// For 0.65 < Ch1/Ch0 <= 0.80
// Lux/Ch0 = 0.00157−0.00180*(Ch1/Ch0)
// For 0.80 < Ch1/Ch0 <= 1.30
// Lux/Ch0 = 0.00338−0.00260*(Ch1/Ch0)
// For Ch1/Ch0 > 1.30
// Lux = 0
//−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−

#define K1C 0x0043 // 0.130 * 2^RATIO_SCALE
#define B1C 0x0204 // 0.0315 * 2^LUX_SCALE
#define M1C 0x01ad // 0.0262 * 2^LUX_SCALE

#define K2C 0x0085 // 0.260 * 2^RATIO_SCALE
#define B2C 0x0228 // 0.0337 * 2^LUX_SCALE
#define M2C 0x02c1 // 0.0430 * 2^LUX_SCALE

#define K3C 0x00c8 // 0.390 * 2^RATIO_SCALE
#define B3C 0x0253 // 0.0363 * 2^LUX_SCALE
#define M3C 0x0363 // 0.0529 * 2^LUX_SCALE

#define K4C 0x010a // 0.520 * 2^RATIO_SCALE
#define B4C 0x0282 // 0.0392 * 2^LUX_SCALE
#define M4C 0x03df // 0.0605 * 2^LUX_SCALE

#define K5C 0x014d // 0.65 * 2^RATIO_SCALE
#define B5C 0x0177 // 0.0229 * 2^LUX_SCALE
#define M5C 0x01dd // 0.0291 * 2^LUX_SCALE

#define K6C 0x019a // 0.80 * 2^RATIO_SCALE
#define B6C 0x0101 // 0.0157 * 2^LUX_SCALE
#define M6C 0x0127 // 0.0180 * 2^LUX_SCALE

#define K7C 0x029a // 1.3 * 2^RATIO_SCALE
#define B7C 0x0037 // 0.00338 * 2^LUX_SCALE
#define M7C 0x002b // 0.00260 * 2^LUX_SCALE

#define K8C 0x029a // 1.3 * 2^RATIO_SCALE
#define B8C 0x0000 // 0.000 * 2^LUX_SCALE
#define M8C 0x0000 // 0.000 * 2^LUX_SCALE

//Enum of all the register addresses as not to put hex numbers in .cpp
enum {
    TSL2561_REGISTER_CONTROL          = 0x00,
    TSL2561_REGISTER_TIMING           = 0x01,
    TSL2561_REGISTER_THRESHHOLDL_LOW  = 0x02,
    TSL2561_REGISTER_THRESHHOLDL_HIGH = 0x03,
    TSL2561_REGISTER_THRESHHOLDH_LOW  = 0x04,
    TSL2561_REGISTER_THRESHHOLDH_HIGH = 0x05,
    TSL2561_REGISTER_INTERRUPT        = 0x06,
    TSL2561_REGISTER_CRC              = 0x08,
    TSL2561_REGISTER_ID               = 0x0A,
    TSL2561_REGISTER_CHAN0_LOW        = 0x0C,
    TSL2561_REGISTER_CHAN0_HIGH       = 0x0D,
    TSL2561_REGISTER_CHAN1_LOW        = 0x0E,
    TSL2561_REGISTER_CHAN1_HIGH       = 0x0F
};

typedef enum {
    TSL2561_INTEGRATIONTIME_13MS      = 0x00,    // 13.7ms
    TSL2561_INTEGRATIONTIME_101MS     = 0x01,    // 101ms
    TSL2561_INTEGRATIONTIME_402MS     = 0x02     // 402ms
}
tsl2561IntegrationTime_t;

typedef enum {
    TSL2561_GAIN_0X                   = 0x00,    // No gain
    TSL2561_GAIN_16X                  = 0x10,    // 16x gain
}
tsl2561Gain_t;

extern Serial pc;

class TSL2561
{
public:
    //create instances
    TSL2561(PinName sda, PinName scl, char slave_address = TSL2561_ADDR_FLOAT);
    TSL2561(I2C &i2c_obj, char slave_adr = TSL2561_ADDR_FLOAT);

    //destructor
    virtual ~TSL2561();

    /** Begin Initialization SI1145 sensor
     *  Configure sensor setting and read parameters for calibration
     */
    //check id register before proceeding
    bool initialize(void);

    //Enable sensor using control register
    void enable(void);
    //Disable sensor using control register
    void disable(void);

    //set the integration time and gain using command, timing, and gain registers
    void setTimingGain(tsl2561IntegrationTime_t integration, tsl2561Gain_t gain);
    
    //read channal 0 and 1, adjust the gain if needed, read again(repeat), and then calculate lux.
    void read_lux(void);
    
    
    uint32_t    lux;        //Final data
    uint16_t    channal0;   //Raw data of vis and ir
    uint16_t    channal1;   //Raw data of just ir
    
    

    //Read data registers than convert to a lux value
    uint32_t calculateLux(uint16_t ch0, uint16_t ch1);

    //get luminosity from data registers
    uint32_t getFullLuminosity (void);
    uint16_t getLuminosity (uint8_t channel);




private:
    I2C         *i2c_p;
    I2C         &i2c;
    char        address;
    tsl2561IntegrationTime_t    _integration;
    tsl2561Gain_t               _gain;


};
#endif
