//CODE BY JAKE LORD
//ALL RIGHTS RESERVED BY VOLCKENS GROUP, FORT COLLINS CO

#ifndef __BLE_UPAS_SERVICE_H__
#define __BLE_UPAS_SERVICE_H__

class UPAS_Service {
public:
    //All Characteristics shall have a read/write counterpart protocol.  This should prevent corruption of data.  
    const static uint16_t UPAS_SERVICE_UUID                     = 0xA000; //UUID of Service.
    
    const static uint16_t RTC_CHARACTERISTIC_UUID               = 0xA002; //UUID for characteristic to write the RTC to 
    GattCharacteristic                rtcCharacteristic;
    
    const static uint16_t SAMPLETIME_CHARACTERISTIC_UUID        = 0xA003; //UUID of variable that app will read from
    GattCharacteristic                sampleTimeCharacteristic;
    
    const static uint16_t SUBJECTLABEL_CHARACTERISTIC_UUID      = 0xA004; //UUID of variable that app will read from
    GattCharacteristic                subjectLabelCharacteristic;
    
    const static uint16_t RUNREADY_CHARACTERISTIC_UUID    = 0xA005; //UUID of variable that app will read from
    GattCharacteristic                runReadyCharacteristic;
    
    const static uint16_t RUNMODE_CHARACTERISTIC_UUID              = 0xA006; //UUID of variable that app will read from
    GattCharacteristic                runModeCharacteristic;


    UPAS_Service(BLE &_ble, bool placeholder, uint8_t *rtc, uint8_t *sampleTime, uint8_t *subjectLabel) :

        rtcCharacteristic(RTC_CHARACTERISTIC_UUID, rtc,6,20, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY ),
        sampleTimeCharacteristic(SAMPLETIME_CHARACTERISTIC_UUID, sampleTime,12,20,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        subjectLabelCharacteristic(SUBJECTLABEL_CHARACTERISTIC_UUID, subjectLabel,15,20,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        runReadyCharacteristic(RUNREADY_CHARACTERISTIC_UUID,0,0,20,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        runModeCharacteristic(RUNMODE_CHARACTERISTIC_UUID,0,0,20,GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        ble(_ble) 
    {
        
        GattCharacteristic *charTable[] = {&rtcCharacteristic, &sampleTimeCharacteristic, &subjectLabelCharacteristic, &runReadyCharacteristic, &runModeCharacteristic}; //Set up characteristics to be broadcasted with the UPAS service
        GattService         upasService(UPAS_Service::UPAS_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *)); //Finally, construct the service
        ble.gattServer().addService(upasService);
    }

private:
    BLE                               &ble;
    
   // ReadOnlyGattCharacteristic<bool>  placeholderState;
};

#endif /* #ifndef __BLE_UPAS_SERVICE_H__ */
